package com.artfess.cgpt.receipt.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 对账单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizReconciliation对象", description="对账单表")
@TableName("biz_reconciliation")
@Data
public class BizReconciliation extends BizModel<BizReconciliation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "收货单ID")
    @TableField("RECEIPT_ID_")
    private String receiptId;

    @ApiModelProperty(value = "对账类型（1：竞价服务费，2：交易服务费，3：没收保证金，默认1）")
    @TableField("REC_TYPE_")
    private Integer recType;

    @ApiModelProperty(value = "对账单号（和支付单号一致）")
    @TableField("ISD_CODE_")
    private String isdCode;

    @ApiModelProperty(value = "创建日期")
    @TableField("ISD_CREATEDATE_")
    private LocalDateTime isdCreatedate;

    @ApiModelProperty(value = "最后修改日期")
    @TableField("ISD_LASTCHGDATE")
    private LocalDateTime isdLastchgdate;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "采购公司编号")
    @TableField("MAT_COMPANY_")
    private String matCompany;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "采购方联系方式")
    @TableField("MAT_COMPANY_PHONE_")
    private String matCompanyPhone;

    @ApiModelProperty(value = "采购商用户ID")
    @TableField("MAT_USER_ID_")
    private String matUserId;

    @ApiModelProperty(value = "采购商用户账号")
    @TableField("MAT_USER_ACCOUNT_")
    private String matUserAccount;

    @ApiModelProperty(value = "采购商用户名称")
    @TableField("MAT_USER_NAME_")
    private String matUserName;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "供应商用户ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "供应商用户账号")
    @TableField("VENDOR_USER_ACCOUNT_")
    private String vendorUserAccount;

    @ApiModelProperty(value = "供应商用户名称")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "供应商联系方式")
    @TableField("VENDOR_PHONE_")
    private String vendorPhone;

    @ApiModelProperty(value = "状态（1：未发布，2：审核中，3：待供应商确认，4：已确认，5：供应商不同意），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "退还保证金状态（0：未退还，1：已退还，默认0），未使用")
    @TableField("REFUND_BOND_STATUS_")
    private Integer refundBondStatus =0;

    @ApiModelProperty(value = "同步到支付平台状态（0：未同步，1：已同步），默认0")
    @TableField("SYNC_STATUS_")
    private Integer syncStatus=0;

    @ApiModelProperty(value = "不含税金额")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "合计税额")
    @TableField("TAX_AMOUNT_")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额")
    @TableField("TOTAL_AMOUNT_")
    private BigDecimal totalAmount;

    @ApiModelProperty(value = "不同意原因")
    @TableField("DISAGREE_REASON_")
    private String disagreeReason;

    @ApiModelProperty(value = "保证金总额")
    @TableField("MARGIN_AMOUNT_")
    private BigDecimal marginAmount;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<BizReconciliationDetail> isdDetail;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
