package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.cgpt.receipt.manager.BizReceiptDetailManager;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.artfess.cgpt.receipt.dao.BizReceiptHandleDao;
import com.artfess.cgpt.receipt.manager.BizReceiptHandleManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.utils.StreamUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购收货单处理记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizReceiptHandleManagerImpl extends BaseManagerImpl<BizReceiptHandleDao, BizReceiptHandle> implements BizReceiptHandleManager {


    @Resource
    private BizReceiptDetailManager bizReceiptDetailManager;

    @Override
    public List<BizReceiptHandle> getByDetailId(String detailId) {
        QueryWrapper<BizReceiptHandle> wrapper = new QueryWrapper<>();
        wrapper.eq("RECEIPT_DETAIL_ID_",detailId);
        wrapper.eq("is_dele_","0");
        List<BizReceiptHandle> list = this.list(wrapper);
        if(null== list || list.isEmpty()){
            return null;
        }

        return list;
    }


    @Override
    public List<BizReceiptHandle> receiptHandleLog(String receiptId) {
        List<BizReceiptDetail> detailList = bizReceiptDetailManager.getByReceiptId(receiptId);

        if(null != detailList && !detailList.isEmpty()){
            List<String> detailIds=new ArrayList<>();
            Map<String, BizReceiptDetail> detailMap = StreamUtil.toMap(detailList, BizReceiptDetail::getId);
            for (BizReceiptDetail bizReceiptDetail : detailList) {
                detailIds.add(bizReceiptDetail.getId());
            }
            QueryWrapper<BizReceiptHandle> wrapper = new QueryWrapper<>();
            wrapper.in("RECEIPT_DETAIL_ID_",detailIds);
            List<BizReceiptHandle> list = this.list(wrapper);
            for (BizReceiptHandle bizReceiptHandle : list) {
                String receiptDetailId = bizReceiptHandle.getReceiptDetailId();
                BizReceiptDetail detail = detailMap.get(receiptDetailId);
                if(null != detail){
                    bizReceiptHandle.setReceiptDetailName(detail.getMatName());
                }
            }
            return list;
        }
       return new ArrayList<>();
    }
}
