package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.receipt.dao.ArrivalDao;
import com.artfess.cgpt.receipt.manager.ArrivalDetailManager;
import com.artfess.cgpt.receipt.manager.ArrivalManager;
import com.artfess.cgpt.receipt.model.Arrival;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.receipt.model.BizReceipt;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:19
 */
@Service
public class ArrivalManagerImpl extends BaseManagerImpl<ArrivalDao, Arrival> implements ArrivalManager {

    @Autowired
    private ArrivalDetailManager arrivalDetailManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    @Override
    public Arrival getDetailById(String id) {
        Arrival result = super.getById(id);
        List<ArrivalDetail> detailList = arrivalDetailManager.getByArrivalId(id);
        result.setDetailList(detailList);
        return result;
    }

    @Override
    @Transactional
    public String saveVo(Arrival entity) {
        List<ArrivalDetail> detailList = entity.getDetailList();

        if(BeanUtils.isEmpty(entity.getId())){
            //新增
            if(BeanUtils.isEmpty(entity.getArrivalCode())){
                entity.setArrivalCode(BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cgfh"));
            }
            entity.setStatus(1);
        }else {
            //更新
            arrivalDetailManager.removeByArrivalId(entity.getId());
        }

        this.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.forEach(s->s.setArrivalId(entity.getId()));
            arrivalDetailManager.saveBatch(detailList);
        }

        return entity.getId();
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        arrivalDetailManager.removeByArrivalId(String.join(",",ids));
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        //状态（1：未发货 ，2：已发货，3： 已收货，4：已结算
        LambdaUpdateWrapper<Arrival> uw = new LambdaUpdateWrapper<>();
        uw.set(Arrival::getStatus,status)
                .eq(Arrival::getId,id)
                .eq(Arrival::getIsDele,"0");
        if(status==2){
            //发货
            IUser user = ContextUtil.getCurrentUser();
            uw.set(Arrival::getVendorUserId,user.getUserId())
                    .set(Arrival::getVendorUserName,user.getFullname())
                    .set(Arrival::getVendorPhone,user.getMobile())
                    .set(Arrival::getArrivalDate, LocalDateTime.now());
        }

        super.update(uw);
    }

    @Override
    public PageList<Arrival> queryByPage(QueryFilter<Arrival> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<Arrival> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<Arrival> pageVendorGroup(QueryFilter<Arrival> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<Arrival> result = baseMapper.pageVendorGroup(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
