package com.artfess.cgpt.receipt.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 采购收货单明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizReceiptDetailManager extends BaseManager<BizReceiptDetail> {

    /**
     * 根据收货单id查询详情
     * @param receipitId
     * @return
     */
    List<BizReceiptDetail> getByReceiptId(String receipitId);

    /**
     * 根据收货单id删除明细
     * @param receiptIds
     */
    void removeByReceiptId(String receiptIds);

    BizReceiptDetail getDetail(String id);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizReceiptDetail> queryAllPage(QueryFilter<BizReceiptDetail> queryFilter);

    void removeHandleLog(List<String> ids);




//    void confirm(List<String> ids);

}
