package com.artfess.cgpt.receipt.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.model.Arrival;
import com.artfess.cgpt.receipt.model.BizReceipt;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:18
 */
public interface ArrivalManager extends BaseManager<Arrival> {

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    Arrival getDetailById(String id);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveVo(Arrival entity);

    /**
     * 根据id集合删除数据
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 根据id修改状态
     * @param id
     * @param status
     */
    void updateStatus(String id, Integer status);

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<Arrival> queryByPage(QueryFilter<Arrival> queryFilter);

    /**
     * 分页查询供应商分组
     * @param queryFilter
     * @return
     */
    PageList<Arrival> pageVendorGroup(QueryFilter<Arrival> queryFilter);

}
