package com.artfess.cgpt.qualification.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.model.BizExpertDatabaseQualificationLabel;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.dao.BizQualificationCategoryDao;
import com.artfess.cgpt.qualification.manager.BizQualificationCategoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 资质类型表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizQualificationCategoryManagerImpl extends BaseManagerImpl<BizQualificationCategoryDao, BizQualificationCategory> implements BizQualificationCategoryManager {

    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private AdmissionConfigQualificationManager admissionConfigQualificationManager;

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizQualificationCategory entity) {
        if(BeanUtils.isEmpty(entity.getCode())){
            entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"zzbqzzbm"));
        }

        if(BeanUtils.isNotEmpty(entity.getId())){
            //判断是否存在关联数据，如果存在，不能编辑
            existData(entity);
        }

        super.saveOrUpdate(entity);
    }

    @Override
    public PageList<BizQualificationCategory> queryAllByPage(QueryFilter<BizQualificationCategory> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizQualificationCategory> iPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        List<BizQualificationCategory> categoryList = super.listByIds(ids);
        for(BizQualificationCategory data : categoryList){
            //判断是否存在关联数据，如果存在，不能删除
            existData(data);
        }
        super.removeByIds(ids);
    }

    /**
     * 校验是否已存在关联数据
     * @param data
     */
    void existData(BizQualificationCategory data){
        //查询资质库
        LambdaQueryWrapper<BizQualificationLabel> quaLabelQW = new LambdaQueryWrapper<>();
        quaLabelQW.eq(BizQualificationLabel::getQualificationTypeCode,data.getCode())
                .eq(BizQualificationLabel::getIsDele,"0");
        if(qualificationLabelManager.count(quaLabelQW)>0){
            throw new BaseException("资质类型编码【"+data.getCode()+"】已存在关联数据，无法操作");
        }

        //查询准入配置
        QueryFilter<AdmissionConfigQualification> configQuaQF = QueryFilter.build();
        configQuaQF.setPageBean(new PageBean(0,-1,false));
        configQuaQF.addFilter("a.QUALIFICATION_CATEGORY_ID_",data.getId(),QueryOP.EQUAL);
        List<AdmissionConfigQualification> configQuaList = admissionConfigQualificationManager.queryByPage(configQuaQF).getRows();
        if(BeanUtils.isNotEmpty(configQuaList) && configQuaList.size()>0){
            throw new BaseException("资质类型编码【"+data.getCode()+"】已存在关联数据，无法操作");
        }

    }

}
