package com.artfess.cgpt.qualification.controller;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * 资质库表，该表需要上传附件 前端控制器
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizQualificationLabel/v1/")
@Api(tags = "资质库表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizQualificationLabelController extends BaseController<BizQualificationLabelManager, BizQualificationLabel> {

    @PostMapping(value = "/saveOrUpdate")
    @ApiOperation(value = "M-添加或修改资质库")
    public CommonResult saveCategory(@RequestBody BizQualificationLabel entity){
        String id = baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功",id);
    }

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizQualificationLabel>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizQualificationLabel> queryFilter) {
        PageList<BizQualificationLabel> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getById")
    @ApiOperation(value = "M-根据ID详情")
    public CommonResult<BizQualificationLabel> getDataById(@ApiParam(name = "id", value = "主键ID") @RequestParam("id") String id) {
        BizQualificationLabel result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id集合删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/updateApprovalStatusById")
    @ApiOperation(value = "M-根据ID修改审核状态")
    public CommonResult updateApprovalStatusById(@RequestParam("id") String id,@RequestParam("status") String status) {
        baseService.updateApprovalStatusById(id,status);
        return new CommonResult<>(true, "操作成功", id);
    }

}
