package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description: 招标/补遗 文件表（上传附件）
 * @Author: Rong Tao
 * @Date: 2024/3/26 19:06
 */
@ApiModel(value="TenderDocument对象", description="招标/补遗 文件表（上传附件）")
@TableName("biz_tender_document")
@Data
public class TenderDocument extends BizModel<TenderDocument> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "类型（1.招标文件，2.补遗文件）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "采购立项ID（关联采购立项表ID）")
    @TableField("PROJECT_APPROVAL_ID_")
    private String projectApprovalId;

    @ApiModelProperty(value = "发布状态（1.未发布，2.已发布）补遗文件使用，默认1")
    @TableField("RELEASE_STATUS_")
    private Integer releaseStatus;

    @ApiModelProperty(value = "是否需要供应商确认（1.否，2.是）")
    @TableField("IS_VENDOR_CONFIRM_")
    private Integer isVendorConfirm;

    @ApiModelProperty(value = "描述（补遗说明）")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "供应商确认状态（0.未确认，1.已确认）")
    @TableField(exist = false)
    private Integer confirmStatus;

}
