package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @Description: 立项评标专家表
 * @Author: Rong Tao
 * @Date: 2024/3/26 19:36
 */
@ApiModel(value="ProjectEvaluationExpert对象", description="立项评标专家表")
@TableName("biz_project_evaluation_expert")
@Data
public class ProjectEvaluationExpert extends BizModel<ProjectEvaluationExpert> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "采购立项ID（关联采购立项表ID）")
    @TableField("PROJECT_APPROVAL_ID_")
    private String projectApprovalId;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "专家姓名")
    @TableField("FULLNAME_")
    private String fullname;

    @ApiModelProperty(value = "专家编号")
    @TableField("USER_NUMBER_")
    private String userNumber;

    @ApiModelProperty(value = "性别（男，女，未知）")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @TableField("BIRTHDAY_")
    private LocalDate birthday;

    @ApiModelProperty(value = "国家")
    @TableField("COUNTRY_")
    private String country;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "政治面貌（使用字典：01中共党员，02中共预备党员，03共青团员，04民革党员，05民盟盟员，06民建会员，07民进会员，08农工党党员，09致公党党员，10九三学社社员，11台盟盟员，12无党派人士，13群众）")
    @TableField("POLITICAL_OUTLOOK_")
    private String politicalOutlook;

    @ApiModelProperty(value = "身份证号")
    @TableField("ID_CARD_")
    private String idCard;

    @ApiModelProperty(value = "工作单位")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "工作地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "参加工作时间")
    @TableField("ENTRY_DATE_")
    private LocalDate entryDate;

    @ApiModelProperty(value = "专家类型（使用字典：1：内部专家，2：外部专家）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "职务")
    @TableField("DUTIES_")
    private String duties;

    @ApiModelProperty(value = "执业资质")
    @TableField("PROFESSIONAL_QUALIFICATIONS_")
    private String professionalQualifications;

    @ApiModelProperty(value = "学历")
    @TableField("EDUCATION_")
    private String education;

    @ApiModelProperty(value = "学位")
    @TableField("ACADEMIC_DEGREE_")
    private String academicDegree;

    @ApiModelProperty(value = "健康状况")
    @TableField("HEALTH_CONDITION_")
    private String healthCondition;

    @ApiModelProperty(value = "办公电话")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "手机号码")
    @TableField("MOBILE_")
    private String mobile;

    @ApiModelProperty(value = "QQ")
    @TableField("QQ_")
    private String qq;

    @ApiModelProperty(value = "MSN")
    @TableField("MSN_")
    private String msn;

    @ApiModelProperty(value = "邮箱")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "所属行政区划_ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_")
    private String sysAreasId;

    @ApiModelProperty(value = "所属行政区划_NAME（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_")
    private String sysAreasName;

    @ApiModelProperty(value = "所属行政区划_全路径ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_PATH_")
    private String sysAreasIdPath;

    @ApiModelProperty(value = "属行政区划_全路径名称（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_PATH_")
    private String sysAreasNamePath;

    @ApiModelProperty(value = "门户账号")
    @TableField("ACCOUNT_")
    private String account;

    @ApiModelProperty(value = "简历")
    @TableField("BIOGRAPHICAL_NOTES_")
    private String biographicalNotes;

    @ApiModelProperty(value = "照片附件URL")
    @TableField("PHOTO_")
    private String photo;

    @ApiModelProperty(value = "专家库ID（关联专家库管理表ID，评标人类型为采购申请人时关联用户id）")
    @TableField("EXPERT_ID_")
    private String expertId;

    @ApiModelProperty(value = "评标人类型（1.专家，2.采购申请人，3.立项人），默认1")
    @TableField("EVALUATOR_TYPE_")
    private Integer evaluatorType;

}
