package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationQualification;
import com.artfess.cgpt.purchasing.dao.PurchasingApplicationQualificationDao;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationQualificationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 采购申请_资质标签关联表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@Service
public class PurchasingApplicationQualificationManagerImpl extends BaseManagerImpl<PurchasingApplicationQualificationDao, PurchasingApplicationQualification> implements PurchasingApplicationQualificationManager {

    @Override
    public PageList<PurchasingApplicationQualification> queryAllByPage(QueryFilter<PurchasingApplicationQualification> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<PurchasingApplicationQualification> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }
}
