package com.artfess.cgpt.purchasing.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.vo.MaterialVo;
import com.artfess.cgpt.purchasing.manager.*;
import com.artfess.cgpt.purchasing.model.*;
import com.artfess.cgpt.purchasing.dao.PurchasingApplicationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.purchasing.vo.PurDetailVo;
import com.artfess.cgpt.purchasing.vo.PurMasterVo;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购申请表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@Service
public class PurchasingApplicationManagerImpl extends BaseManagerImpl<PurchasingApplicationDao, PurchasingApplication> implements PurchasingApplicationManager {

    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private PurchasingUnitManager purchasingUnitManager;
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private PurchasingApplicationAuditRecordsManager auditRecordsManager;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private BizMaterialManager materialManager;

    @Override
    public PageList<PurchasingApplication> curOrgData(QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        IPage<PurchasingApplication> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        List<PurchasingApplication> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(PurchasingApplication temp : records){
                temp.setAccessoryList(accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }

        return new PageList<>(result);
    }

    @Override
    public PageList<PurchasingApplication> queryAllByPage(QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        IPage<PurchasingApplication> result = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    //2024-06-13 15:30
//    @Override
//    @Transactional
//    public void saveOrUpdateEntity(PurchasingApplication entity) {
//        List<PurchasingApplicationDetails> detailsList = entity.getDetailsList();
//        List<PurchasingUnit> unitList = entity.getUnitList();
//        List<PurchasingApplicationQualification> qualificationList = entity.getQualificationList();
//        List<Accessory> quaAccessoryList = entity.getQuaAccessoryList();
//
//        if(BeanUtil.isEmpty(entity.getId())){
//            //新增，生成编号
//            String cgsq_sqdbh = BizUtils.getNextSerialNumber(systemConfigFeignService, "cgsq_sqdbh");
//            entity.setApplicationNum(cgsq_sqdbh);
//        }else {
//            //先清除已有明细
//            LambdaQueryWrapper<PurchasingUnit> wrapper1 = new LambdaQueryWrapper<>();
//            wrapper1.eq(PurchasingUnit::getPurchasingApplicationId,entity.getId());
//            LambdaQueryWrapper<PurchasingApplicationDetails> wrapper2 = new LambdaQueryWrapper<>();
//            wrapper2.eq(PurchasingApplicationDetails::getPurchasingApplicationId,entity.getId());
//            LambdaQueryWrapper<PurchasingApplicationQualification> wrapper3 = new LambdaQueryWrapper<>();
//            wrapper3.eq(PurchasingApplicationQualification::getPurchasingApplicationId,entity.getId());
//
//            purchasingUnitManager.remove(wrapper1);
//            applicationDetailsManager.remove(wrapper2);
//            applicationQualificationManager.remove(wrapper3);
//
//            //删除资质附件
//            accessoryService.removeBySourceId(entity.getId());
//        }
//        super.saveOrUpdate(entity);
//
//        //保存采购申请明细
//        if(BeanUtil.isNotEmpty(detailsList) && detailsList.size()>0){
//            detailsList.stream().forEach(s->{
//                s.setPurchasingApplicationId(entity.getId());
//            });
//            applicationDetailsManager.saveBatch(detailsList);
//        }
//
//        //保存采购单位
//        if(BeanUtil.isNotEmpty(unitList) && unitList.size()>0){
//            unitList.stream().forEach(s->{
//                s.setPurchasingApplicationId(entity.getId());
//            });
//            purchasingUnitManager.saveBatch(unitList);
//        }
//
//        //保存资质标签
//        if(BeanUtil.isNotEmpty(qualificationList) && qualificationList.size()>0){
//            qualificationList.stream().forEach(s->{
//                s.setPurchasingApplicationId(entity.getId());
//            });
//            applicationQualificationManager.saveBatch(qualificationList);
//        }
//
//        //资质附件
//        if(BeanUtils.isNotEmpty(quaAccessoryList) && quaAccessoryList.size()>0){
//            quaAccessoryList.stream().forEach(accessory->{
//                accessory.setSourceId(entity.getId());
//            });
//            accessoryService.saveBatch(quaAccessoryList);
//        }
//
//    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(PurchasingApplication entity) {
        List<PurchasingApplicationDetails> detailsList = entity.getDetailsList();
        List<PurchasingUnit> unitList = entity.getUnitList();
        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtils.isEmpty(entity.getPreparedUserId())){
            entity.setPreparedUserId(ContextUtil.getCurrentUserId());
            entity.setPreparedUserName(ContextUtil.getCurrentUserName());
        }

        if(BeanUtils.isEmpty(entity.getProcurementMethod())){
            throw new BaseException("定价方式不能为空");
        }

        if(BeanUtil.isEmpty(entity.getId())){
            //新增，生成编号
//            String cgsq_sqdbh = BizUtils.getNextSerialNumber(systemConfigFeignService, "cgsq_sqdbh");
//            entity.setApplicationNum(cgsq_sqdbh);
            if(BeanUtils.isEmpty(entity.getApplicationNum())){
                throw new BaseException("申请单号不能为空");
            }
        }else {
            //先清除已有明细
            LambdaQueryWrapper<PurchasingUnit> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.eq(PurchasingUnit::getPurchasingApplicationId,entity.getId());
            LambdaQueryWrapper<PurchasingApplicationDetails> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(PurchasingApplicationDetails::getPurchasingApplicationId,entity.getId());
            purchasingUnitManager.remove(wrapper1);
            applicationDetailsManager.remove(wrapper2);
            //删除相关附件
            accessoryService.removeBySourceId(entity.getId());
        }

        if(entity.getIsAgencyProcure()==1){
            //代采
            if(BeanUtils.isEmpty(entity.getAgencyProcureOrgId())){
                throw new BaseException("请选择代采单位");
            }
        }

        super.saveOrUpdate(entity);

        //保存采购申请明细
        if(BeanUtil.isNotEmpty(detailsList) && detailsList.size()>0){
            detailsList.stream().forEach(s->{
                if(BeanUtils.isEmpty(s.getPlanCode())){
                    throw new BaseException("计划编号不能为空");
                }
                s.setPurchasingApplicationId(entity.getId());
            });
            applicationDetailsManager.saveBatch(detailsList);
        }

        //保存采购单位
        if(BeanUtil.isNotEmpty(unitList) && unitList.size()>0){
            unitList.stream().forEach(s->{
                s.setPurchasingApplicationId(entity.getId());
            });
            purchasingUnitManager.saveBatch(unitList);
        }

        //相关文件
        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.stream().forEach(accessory->{
                accessory.setSourceId(entity.getId());
            });
            accessoryService.saveBatch(accessoryList);
        }

        return entity.getId();
    }

    @Override
    public PurchasingApplication getDataById(String id) {
        PurchasingApplication result = super.getById(id);
        //查询采购申请明细
        LambdaQueryWrapper<PurchasingApplicationDetails> detailsQW=new LambdaQueryWrapper<>();
        detailsQW.eq(PurchasingApplicationDetails::getPurchasingApplicationId, id);
        List<PurchasingApplicationDetails> detailsList = applicationDetailsManager.list(detailsQW);
        //查询采购单位
        LambdaQueryWrapper<PurchasingUnit> unitQW = new LambdaQueryWrapper<>();
        unitQW.eq(PurchasingUnit::getPurchasingApplicationId, id);
        List<PurchasingUnit> unitList = purchasingUnitManager.list(unitQW);

        result.setDetailsList(detailsList);
        result.setUnitList(unitList);
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));

        return result;
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        //删除采购申请表
        super.removeByIds(ids);
        //删除采购申请明细
        LambdaQueryWrapper<PurchasingApplicationDetails> detailsQW = new LambdaQueryWrapper<>();
        detailsQW.in(PurchasingApplicationDetails::getPurchasingApplicationId, ids);
        applicationDetailsManager.remove(detailsQW);
        //删除相关附件
        accessoryService.removeBySourceIds(ids);
    }

    @Override
    @Transactional
    public void updateStatus(String ids, String status) {
        List<PurchasingApplication> list = super.listByIds(Arrays.asList(ids.split(",")));
        List<PurchasingApplicationAuditRecords> auditRecordsList = new ArrayList<>();
        for(PurchasingApplication data : list){
            data.setStatus(Integer.valueOf(status));

            if(status.equals("3")){
                //如果状态为已审批
                data.setAuditingUser(ContextUtil.getCurrentUserName());
                data.setAuditingDate(LocalDateTime.now());

                PurchasingApplicationAuditRecords auditRecords = new PurchasingApplicationAuditRecords();
                auditRecords.setApplicationId(data.getId());
                auditRecords.setApplicationNum(data.getApplicationNum());
                auditRecords.setStatus(1);
                auditRecords.setAuditingDate(data.getAuditingDate());
                auditRecords.setAuditingUser(data.getAuditingUser());
                auditRecordsList.add(auditRecords);
            }

            if(status.equals("8")){
                //如果状态为驳回
                data.setAuditingUser(ContextUtil.getCurrentUserName());
                data.setAuditingDate(LocalDateTime.now());

                PurchasingApplicationAuditRecords auditRecords = new PurchasingApplicationAuditRecords();
                auditRecords.setApplicationId(data.getId());
                auditRecords.setApplicationNum(data.getApplicationNum());
                auditRecords.setStatus(2);
                auditRecords.setAuditingDate(data.getAuditingDate());
                auditRecords.setAuditingUser(data.getAuditingUser());
                auditRecords.setAuditingReason(data.getAuditingReason());
                auditRecordsList.add(auditRecords);
            }

            if(status.equals("1")){
                //撤回为草稿
                //查询采购申请审核记录是否存在数据
//                LambdaQueryWrapper<PurchasingApplicationAuditRecords> auditRecordQW = new LambdaQueryWrapper<>();
//                auditRecordQW.eq(PurchasingApplicationAuditRecords::getApplicationId,data.getId());
//                if(auditRecordsManager.count(auditRecordQW)>0){
//                    //如果存在就不能撤回
//                    throw new BaseException("【"+data.getApplicationNum()+"】申请单已有审批记录，撤回失败");
//                }

            }

        }
        super.updateBatchById(list);
        if(auditRecordsList.size()>0){
            auditRecordsManager.saveBatch(auditRecordsList);
        }
    }

    @Override
    @Transactional
    public void modifyStatusById(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper<PurchasingApplication> uw = new LambdaUpdateWrapper<>();
        uw.set(PurchasingApplication::getStatus,status)
                .in(PurchasingApplication::getId,idList)
                .eq(PurchasingApplication::getIsDele,"0");

        if(status.equals("3")){
            //如果状态为已审批
            uw.set(PurchasingApplication::getAuditingUser,ContextUtil.getCurrentUserName())
                    .set(PurchasingApplication::getAuditingDate,LocalDateTime.now());
        }
        super.update(uw);
    }

    //2024-07-27 10:26
//    @Override
//    @Transactional
//    public Response saveOrUpdateByApi(JSONObject param) {
//        String code = "0";
//        String message = "操作成功";
//        String errDetail = "";
//        try {
//            List<PurMasterVo> data = JSONUtil.toList(param.getJSONArray("data"), PurMasterVo.class);
//            List<PurchasingApplication> list = purConvertApplication(data);
//            for(PurchasingApplication pur : list){
//                boolean isUpdateDetail = false;
//                List<PurchasingApplicationDetails> detailsList = pur.getDetailsList();
//                //1.保存采购申请主表
//                LambdaQueryWrapper<PurchasingApplication> applicationHisQW = new LambdaQueryWrapper<>();
//                applicationHisQW.eq(PurchasingApplication::getApplicationNum,pur.getApplicationNum())
//                        .eq(PurchasingApplication::getIsDele,"0")
//                        .last("limit 1");
//                PurchasingApplication applicationHis = baseMapper.selectOne(applicationHisQW);
//                if(BeanUtils.isEmpty(applicationHis)){
//                    super.save(pur);
//                    isUpdateDetail = true;
//                }else {
//                    pur.setId(applicationHis.getId());
//                    if(applicationHis.getStatus()==1 || applicationHis.getStatus()==8){
//                        //如果是草稿状态或驳回状态
//                        isUpdateDetail = true;
//                    }
//                }
//
//                if(isUpdateDetail){
//                    //删除申请明细
//                    LambdaQueryWrapper<PurchasingApplicationDetails> detailQW = new LambdaQueryWrapper<>();
//                    detailQW.eq(PurchasingApplicationDetails::getPurchasingApplicationId,pur.getId());
//                    applicationDetailsManager.remove(detailQW);
//                    if(BeanUtils.isNotEmpty(detailsList) && detailsList.size()>0){
//                        detailsList.forEach(s->s.setPurchasingApplicationId(pur.getId()));
//                    }
//                    applicationDetailsManager.saveBatch(detailsList);
//                }
//            }
//
//        }catch (Exception e){
//            e.printStackTrace();
//            code = "500";
//            errDetail = e.getMessage();
//            message = "操作失败:"+errDetail;
//            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//        }
//
//        return new Response<>(code, message, errDetail);
//    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "操作成功";
        String errDetail = null;
        try {
            List<PurMasterVo> data = JSONUtil.toList(param.getJSONArray("data"), PurMasterVo.class);
            List<PurchasingApplication> list = purConvertApplication(data);
            for(PurchasingApplication pur : list){
                List<PurchasingApplicationDetails> detailsList = pur.getDetailsList();
                //1.删除原有申请单
                LambdaQueryWrapper<PurchasingApplication> applicationHisQW = new LambdaQueryWrapper<>();
                applicationHisQW.eq(PurchasingApplication::getApplicationNum,pur.getApplicationNum())
                        .eq(PurchasingApplication::getMatIfPlat,pur.getMatIfPlat())
                        .eq(PurchasingApplication::getApplicationSource,2)
                        .eq(PurchasingApplication::getIsDele,"0");
                List<PurchasingApplication> appHisList = super.list(applicationHisQW);
                if(BeanUtils.isNotEmpty(appHisList) && appHisList.size()>0){
                    List<String> collect = new ArrayList<>();
                    for(PurchasingApplication s : appHisList){
                        if(s.getStatus()!= 1 && s.getStatus()!= 8){
                            throw new BaseException("申请单【"+s.getApplicationNum()+"】已处理，无法重新导入");
                        }
                        collect.add(s.getId());
                    }
                    //删除原有申请明细
                    LambdaQueryWrapper<PurchasingApplicationDetails> applicationDetailHisQW = new LambdaQueryWrapper<>();
                    applicationDetailHisQW.in(PurchasingApplicationDetails::getPurchasingApplicationId,collect);
                    applicationDetailsManager.remove(applicationDetailHisQW);
                }
                super.remove(applicationHisQW);

                //2.保存采购申请
                super.save(pur);
                if(BeanUtils.isNotEmpty(detailsList) && detailsList.size()>0){
                    detailsList.forEach(s->{
                        s.setPurchasingApplicationId(pur.getId());
                        if(BeanUtils.isEmpty(s.getApplicationNum())){
                            s.setApplicationNum(pur.getApplicationNum());
                        }
                    });
                }
                applicationDetailsManager.saveBatch(detailsList);
            }

        }catch (Exception e){
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "操作失败:"+errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }

        return new Response<>(code, message, errDetail);
    }

    /**
     * 主数据采购申请单转换为采购平台采购申请
     * @param purList
     * @return
     */
    List<PurchasingApplication> purConvertApplication(List<PurMasterVo> purList){
        List<PurchasingApplication> result = new ArrayList<>();
        for(PurMasterVo pur : purList){
            List<PurDetailVo> purDetailList = pur.getDetailList();
            //根据企业历史编号查询企业信息
            LambdaQueryWrapper<Enterprise> enterpriseQW = new LambdaQueryWrapper<>();
            enterpriseQW.and(s->s.eq(Enterprise::getHistoryCompanyCode,pur.getMatCompany())
                            .or().eq(Enterprise::getCompanyCode,pur.getMatCompany()))
                    .eq(Enterprise::getIsDele,"0")
                    .orderByDesc(Enterprise::getCreateTime)
                    .last("limit 1");
            Enterprise enterprise = enterpriseManager.getBaseMapper().selectOne(enterpriseQW);
            if(BeanUtils.isEmpty(enterprise)){
                throw new BaseException("请先推送企业【"+pur.getMatCompany()+"】到采购平台");
            }

            if(BeanUtils.isNotEmpty(purDetailList) && purDetailList.size()>0){
                //根据明细是否集采分组
                Map<Integer, List<PurDetailVo>> collect = purDetailList.stream().collect(Collectors.groupingBy(s -> s.getMatIfPlat()));
                collect.forEach((matIfPlat,detailVoList)->{
                    //根据是否集采拆分采购申请主表
                    PurchasingApplication temp = new PurchasingApplication();
                    temp.setApplicationNum(pur.getPrbillCode());

                    //根据公司和编制人名称查询id
//                    LambdaQueryWrapper<User> userQW = new LambdaQueryWrapper<>();
//                    userQW.select(User::getId)
//                            .eq(User::getFullname,pur.getPurCreator())
//                            .eq(User::getIsDelete,"0")
//                            .groupBy(User::getId);
//                    List<Object> userIdObjs = userManager.listObjs(userQW);
//                    if(BeanUtils.isNotEmpty(userIdObjs) && userIdObjs.size()>0){
//                        List<String> userIds = userIdObjs.stream().map(s->String.valueOf(s)).collect(Collectors.toList());
//                        LambdaQueryWrapper<OrgUser> orgUserQW = new LambdaQueryWrapper<>();
//                        orgUserQW.select(OrgUser::getUserId)
//                                .eq(OrgUser::getOrgId,enterprise.getOrgId())
//                                .in(OrgUser::getUserId,userIds)
//                                .eq(OrgUser::getIsDelete,"0");
//                        List<Object> objs = orgUserManager.listObjs(orgUserQW);
//                        if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
//                            temp.setPreparedUserId(String.valueOf(objs.get(0)));
//                        }
//                    }

                    temp.setPreparedUserName(pur.getPurCreator());
                    temp.setPreparedOrgId(enterprise.getOrgId());
                    temp.setPreparedOrgCode(enterprise.getCompanyCode());
                    temp.setPreparedOrgName(enterprise.getCompanyName());
                    temp.setPurBzbm(pur.getPurBzbm());
                    temp.setPreparedDate(pur.getPurCreatedate().toLocalDate());
                    temp.setHasQualification(0);
                    temp.setApplicationSource(2);
                    temp.setStatus(1);
                    temp.setMergeStatus(1);
                    temp.setIsAgencyProcure(0);
                    temp.setApplicationDate(temp.getPreparedDate());
                    temp.setMatIfPlat(matIfPlat);

                    List<PurchasingApplicationDetails> applicationDetailList = new ArrayList<>();
                    for(PurDetailVo detailVo : detailVoList){
                        PurchasingApplicationDetails detail = new PurchasingApplicationDetails();
                        detail.setApplicationNum(detailVo.getPrbillCode());
                        detail.setPlanCode(detailVo.getPlanCode());
                        LambdaQueryWrapper<BizMaterial> matQW = new LambdaQueryWrapper<>();
                        matQW.eq(BizMaterial::getMatPlatcode,detailVo.getMatPlatcode())
                                .eq(BizMaterial::getIsDele,"0")
                                .orderByDesc(BizMaterial::getCreateTime)
                                .last("limit 1");
                        if(BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode())){
                            matQW.and(s->s.eq(BizMaterial::getMatCompanyCode,enterprise.getCompanyCode())
                                    .or().eq(BizMaterial::getMatCompanyCode,enterprise.getHistoryCompanyCode()));
                        }else {
                            matQW.eq(BizMaterial::getMatCompanyCode,enterprise.getCompanyCode());
                        }

                        BizMaterial mat = materialManager.getBaseMapper().selectOne(matQW);
                        if(BeanUtils.isEmpty(mat)){
                            throw new BaseException("请先推送物料【"+detailVo.getMatPlatcode()+"】到采购平台");
                        }
                        detail.setMatId(mat.getId());
                        detail.setMatCompanyId(enterprise.getOrgId());
                        detail.setMatCompanyCode(enterprise.getCompanyCode());
                        detail.setMatCompanyName(enterprise.getCompanyName());
                        detail.setMatCategory(mat.getMatCategory());
                        detail.setMatCode(detailVo.getMatCode());
                        detail.setMatPlatcode(detailVo.getMatPlatcode());
                        detail.setMatName(detailVo.getMatName());
                        detail.setMatMaterial(mat.getMatMaterial());
                        detail.setMatSpec(mat.getMatSpec());
                        detail.setMatBrand(mat.getMatBrand());
                        detail.setMatBaseExt(mat.getMatBaseExt());
                        detail.setMatOtherExt(mat.getMatOtherExt());
                        detail.setMatUnit(mat.getMatUnit());
                        detail.setMatNum(detailVo.getPurQuantity());
                        detail.setDemandDate(detailVo.getPurReqdate());
                        detail.setPlannedPrice(detailVo.getTaxInprice());
                        detail.setUnloadAddress(detailVo.getUnloadAddress());
                        detail.setTaxRate(mat.getMatTaxrate());
                        if(mat.getMatTaxrate()==0){
                            detail.setIsTax(2);
                        }else {
                            detail.setIsTax(1);
                        }
                        detail.setMatIfPlat(detailVo.getMatIfPlat());
                        detail.setRemarks(detailVo.getPurNote());
                        detail.setMaximumPriceLimit(detailVo.getTaxInprice());
                        detail.setStatus(1);
                        applicationDetailList.add(detail);
                    }
                    temp.setDetailsList(applicationDetailList);
                    result.add(temp);
                });

            }else {
                PurchasingApplication temp = new PurchasingApplication();
                temp.setApplicationNum(pur.getPrbillCode());
                temp.setPreparedUserName(pur.getPurCreator());
                temp.setPreparedOrgId(enterprise.getOrgId());
                temp.setPreparedOrgCode(enterprise.getCompanyCode());
                temp.setPreparedOrgName(enterprise.getCompanyName());
                temp.setPurBzbm(pur.getPurBzbm());
                temp.setPreparedDate(pur.getPurCreatedate().toLocalDate());
                temp.setHasQualification(0);
                temp.setApplicationSource(2);
                temp.setStatus(1);
                temp.setMergeStatus(1);
                temp.setIsAgencyProcure(0);
                temp.setApplicationDate(temp.getPreparedDate());
                result.add(temp);
            }
        }


        return result;
    }


    //2024-07-27 10:12
//    /**
//     * 主数据采购申请单转换为采购平台采购申请
//     * @param purList
//     * @return
//     */
//    List<PurchasingApplication> purConvertApplication(List<PurMasterVo> purList){
//        List<PurchasingApplication> result = new ArrayList<>();
//        for(PurMasterVo pur : purList){
//            List<PurDetailVo> purDetailList = pur.getDetailList();
//            PurchasingApplication temp = new PurchasingApplication();
//            temp.setApplicationNum(pur.getPrbillCode());
//            temp.setPreparedUserName(pur.getPurCreator());
//
//            //根据企业历史编号查询企业信息
//            LambdaQueryWrapper<Enterprise> enterpriseQW = new LambdaQueryWrapper<>();
//            enterpriseQW.and(s->s.eq(Enterprise::getHistoryCompanyCode,pur.getMatCompany())
//                            .or().eq(Enterprise::getCompanyCode,pur.getMatCompany()))
//                    .eq(Enterprise::getIsDele,"0")
//                    .orderByDesc(Enterprise::getCreateTime)
//                    .last("limit 1");
//            Enterprise enterprise = enterpriseManager.getBaseMapper().selectOne(enterpriseQW);
//            if(BeanUtils.isEmpty(enterprise)){
//                throw new BaseException("请先推送企业【"+pur.getMatCompany()+"】到采购平台");
//            }
//            temp.setPreparedOrgId(enterprise.getOrgId());
//            temp.setPreparedOrgCode(enterprise.getCompanyCode());
//            temp.setPreparedOrgName(enterprise.getCompanyName());
//            temp.setPurBzbm(pur.getPurBzbm());
//            temp.setPreparedDate(pur.getPurCreatedate().toLocalDate());
//            temp.setHasQualification(0);
//            temp.setApplicationSource(2);
//            temp.setStatus(1);
//            temp.setMergeStatus(1);
//            temp.setIsAgencyProcure(0);
//
//            if(BeanUtils.isNotEmpty(purDetailList) && purDetailList.size()>0){
//                PurDetailVo tempDetail = purDetailList.get(0);
//                temp.setApplicationDate(tempDetail.getPurReqdate());
//                temp.setMatIfPlat(tempDetail.getMatIfPlat());
//                List<PurchasingApplicationDetails> applicationDetailList = new ArrayList<>();
//                for(PurDetailVo detailVo : purDetailList){
//                    PurchasingApplicationDetails detail = new PurchasingApplicationDetails();
//                    detail.setPlanCode(detailVo.getPlanCode());
//                    LambdaQueryWrapper<BizMaterial> matQW = new LambdaQueryWrapper<>();
//                    matQW.eq(BizMaterial::getMatPlatcode,detailVo.getMatPlatcode())
//                            .eq(BizMaterial::getIsDele,"0")
//                            .orderByDesc(BizMaterial::getCreateTime)
//                            .last("limit 1");
//                    BizMaterial mat = materialManager.getBaseMapper().selectOne(matQW);
//                    if(BeanUtils.isEmpty(mat)){
//                        throw new BaseException("请先推送物料【"+detailVo.getMatPlatcode()+"】到采购平台");
//                    }
//                    detail.setMatId(mat.getId());
//                    detail.setMatCompanyId(enterprise.getOrgId());
//                    detail.setMatCompanyCode(enterprise.getCompanyCode());
//                    detail.setMatCompanyName(enterprise.getCompanyName());
//                    detail.setMatCategory(mat.getMatCategory());
//                    detail.setMatCode(detailVo.getMatCode());
//                    detail.setMatPlatcode(detailVo.getMatPlatcode());
//                    detail.setMatName(detailVo.getMatName());
//                    detail.setMatMaterial(mat.getMatMaterial());
//                    detail.setMatSpec(mat.getMatSpec());
//                    detail.setMatBrand(mat.getMatBrand());
//                    detail.setMatBaseExt(mat.getMatBaseExt());
//                    detail.setMatOtherExt(mat.getMatOtherExt());
//                    detail.setMatUnit(mat.getMatUnit());
//                    detail.setMatNum(detailVo.getPurQuantity());
//                    detail.setDemandDate(detailVo.getPurReqdate());
//                    detail.setPlannedPrice(detailVo.getTaxInprice());
//                    detail.setUnloadAddress(detailVo.getUnloadAddress());
//                    detail.setTaxRate(mat.getMatTaxrate());
//                    if(mat.getMatTaxrate()==0){
//                        detail.setIsTax(2);
//                    }else {
//                        detail.setIsTax(1);
//                    }
//                    detail.setMatIfPlat(detailVo.getMatIfPlat());
//                    detail.setRemarks(detailVo.getPurNote());
//                    detail.setMaximumPriceLimit(detailVo.getTaxInprice());
//                    detail.setStatus(1);
//                    applicationDetailList.add(detail);
//                }
//                temp.setDetailsList(applicationDetailList);
//            }else {
//                temp.setApplicationDate(temp.getPreparedDate());
//            }
//
//            result.add(temp);
//        }
//
//
//        return result;
//    }

}
