package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.purchasing.dao.PurchasingApplicationDetailsDao;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.manager.BizDeliveryAddressManager;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.BizDeliveryAddress;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 物料采购申请明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@Service
public class PurchasingApplicationDetailsManagerImpl extends BaseManagerImpl<PurchasingApplicationDetailsDao, PurchasingApplicationDetails> implements PurchasingApplicationDetailsManager {

    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private BizDeliveryAddressManager addressManager;
    @Autowired
    private EnterpriseManager enterpriseManager;

    @Override
    public PageList<PurchasingApplicationDetails> queryAllByPage(QueryFilter<PurchasingApplicationDetails> queryFilter) {
//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<PurchasingApplicationDetails> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public List<PurchasingApplicationDetails> excelToData(MultipartFile file) throws Exception {
        List<PurchasingApplicationDetails> data = ExcelImportUtil.importExcel(file.getInputStream(), PurchasingApplicationDetails.class, new ImportParams());
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(PurchasingApplicationDetails temp :data){
                //1.根据平台物料编号查询物料表
                if (BeanUtils.isEmpty(temp.getMatPlatcode())) {
                    throw new BaseException("请填入平台物料编号");
                }
                if (BeanUtils.isEmpty(temp.getDemandDateValue())){
                    throw new BaseException("请填入需求日期");
                }
                if (BeanUtils.isEmpty(temp.getMatNum())){
                    throw new BaseException("请填入数量");
                }

                IGroup org = ContextUtil.getCurrentGroup();
                Enterprise enterprise = enterpriseManager.getByOrgIdOrCode(org.getGroupId(), org.getGroupCode());
                if(BeanUtils.isEmpty(enterprise)){
                    throw new BaseException("当前企业信息未找到，请前往主数据推送企业");
                }

                temp.setMatPlatcode(temp.getMatPlatcode().trim());

                LambdaQueryWrapper<BizMaterial> materialQW = new LambdaQueryWrapper<>();
                materialQW.eq(BizMaterial::getMatPlatcode,temp.getMatPlatcode())
                        .and(s->s.eq(BizMaterial::getMatCompanyCode,enterprise.getCompanyCode())
                                .or(BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode()))
                                .eq(BizMaterial::getMatCompanyCode,enterprise.getHistoryCompanyCode()))
                        .eq(BizMaterial::getIsDele,"0")
                        .orderByDesc(BizMaterial::getCreateTime)
                        .last("limit 1");
                BizMaterial material = materialManager.getBaseMapper().selectOne(materialQW);
                if(BeanUtils.isEmpty(material)){
                    throw new BaseException("平台物料编号【"+temp.getMatPlatcode()+"】未找到企业物料，请输入正确的平台物料编号或生成企业物料");
                }
                if(BeanUtils.isNotEmpty(temp.getDemandDateValue())){
                    temp.setDemandDate(LocalDate.parse(temp.getDemandDateValue()));
                }

                //赋值物料属性
                temp.setMatId(material.getId());
                temp.setMatCompanyId(material.getMatCompanyId());
                temp.setMatCompanyCode(material.getMatCompanyCode());
                temp.setMatCompanyName(material.getMatCompanyName());
                temp.setMatCategory(material.getMatCategory());
                temp.setMatCode(material.getMatCode());
                temp.setMatName(material.getMatName());
                temp.setMatMaterial(material.getMatMaterial());
                temp.setMatSpec(material.getMatSpec());
                temp.setMatBrand(material.getMatBrand());
                temp.setMatBaseExt(material.getMatBaseExt());
                temp.setMatOtherExt(material.getMatOtherExt());
                temp.setMatUnit(material.getMatUnit());
                temp.setTaxRate(material.getMatTaxrate());

                //根据送货地址编号获取地址
//                if(BeanUtils.isNotEmpty(temp.getUnloadAddress())){
//                    LambdaQueryWrapper<BizDeliveryAddress> addressQW = new LambdaQueryWrapper<>();
//                    addressQW.eq(BizDeliveryAddress::getEnterpriseId, ContextUtil.getCurrentOrgId())
//                            .eq(BizDeliveryAddress::getCode,temp.getUnloadAddress())
//                            .eq(BizDeliveryAddress::getIsDele,"0")
//                            .orderByDesc(BizDeliveryAddress::getCreateTime)
//                            .last("limit 1");
//                    BizDeliveryAddress address = addressManager.getBaseMapper().selectOne(addressQW);
//                    if(BeanUtils.isNotEmpty(address)){
//                        temp.setUnloadAddress(address.getEnterpriseContactAddress());
//                    }
//                }

            }
        }

        return data;
    }

    @Override
    public void exportDataToExcel(QueryFilter<PurchasingApplicationDetails> queryFilter, HttpServletResponse response) throws Exception {
        String fileName = "采购申请明细-导出结果";

        // 获取数据
        List<PurchasingApplicationDetails> data = queryAllByPage(queryFilter).getRows();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);

        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, PurchasingApplicationDetails.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

}
