package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.cgpt.purchasing.model.BizPurchaseOrderDetail;
import com.artfess.cgpt.purchasing.dao.BizPurchaseOrderDetailDao;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderDetailManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 采购订单明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@Service
public class BizPurchaseOrderDetailManagerImpl extends BaseManagerImpl<BizPurchaseOrderDetailDao, BizPurchaseOrderDetail> implements BizPurchaseOrderDetailManager {


    @Override
    public List<BizPurchaseOrderDetail> getListByOrderId(String orderId) {
        LambdaQueryWrapper<BizPurchaseOrderDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizPurchaseOrderDetail::getOrderId,orderId);
        return super.list(wrapper);
    }

    @Override
    public void delByOrderId(String orderId) {
        LambdaQueryWrapper<BizPurchaseOrderDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizPurchaseOrderDetail::getOrderId,orderId);
        this.remove(wrapper);
    }
}
