package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 19:09
 */
public interface TenderDocumentManager extends BaseManager<TenderDocument> {

    /**
     * 根据立项id判断当前供应商是否确认文件
     * @param noticeId 立项id
     * @return
     */
    Boolean queryConfirmStatus(String noticeId);

    /**
     * 判断当前供应商是否确认文件
     * @param queryFilter
     * @return
     */
    Boolean queryConfirmStatus(QueryFilter<TenderDocument> queryFilter);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<TenderDocument> queryAllByPage(QueryFilter<TenderDocument> queryFilter);

    /**
     * 分页查询所有数据（带附件）
     * @param queryFilter
     * @return
     */
    PageList<TenderDocument> pageAccessory(QueryFilter<TenderDocument> queryFilter);

    /**
     * 修改发布状态
     * @param ids
     * @param status
     */
    void modifyReleaseStatus(String ids,String status);

    /**
     * 根据id集合删除数据
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 上传补遗文件
     * @param docList
     */
    void uploadByDoc(List<TenderDocument> docList);

}
