package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 物料采购申请明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
public interface PurchasingApplicationDetailsManager extends BaseManager<PurchasingApplicationDetails> {

    PageList<PurchasingApplicationDetails> queryAllByPage(QueryFilter<PurchasingApplicationDetails> queryFilter);

    /**
     * 根据Excel文件转换数据
     * @param file 文件
     * @throws Exception
     */
    List<PurchasingApplicationDetails> excelToData(MultipartFile file) throws Exception;

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<PurchasingApplicationDetails> queryFilter, HttpServletResponse response) throws Exception;

}
