package com.artfess.cgpt.purchasing.dao;

import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsEvaExportVO;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsExportVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 10:18
 */
public interface MatApprovalDetailsDao extends BaseMapper<MatApprovalDetails> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApprovalDetailsEvaExportVO> queryEvaExportVoByPage(IPage<MatApprovalDetails> convert2IPage, @Param("ew") Wrapper<MatApprovalDetails> convert2Wrapper);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApprovalDetails> queryAllByPage(IPage<MatApprovalDetails> convert2IPage, @Param("ew") Wrapper<MatApprovalDetails> convert2Wrapper);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApprovalDetailsExportVO> queryVoByPage(IPage<MatApprovalDetails> convert2IPage, @Param("ew") Wrapper<MatApprovalDetails> convert2Wrapper);

    /**
     * 分页查询评标明细
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApprovalDetails> queryEvaData(IPage<MatApprovalDetails> convert2IPage, @Param("ew") Wrapper<MatApprovalDetails> convert2Wrapper);

    /**
     * 分页查询报价公司明细
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApprovalDetails> quoDataQuery(IPage<MatApprovalDetails> convert2IPage, @Param("ew") Wrapper<MatApprovalDetails> convert2Wrapper);

}
