package com.artfess.cgpt.purchasing.dao;

import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * 采购订单表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
public interface BizPurchaseOrderDao extends BaseMapper<BizPurchaseOrder> {

    /**
     * 分页查询采购商分组
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizPurchaseOrder> pageMatCompanyGroup(IPage<BizPurchaseOrder> convert2IPage, @Param("ew") Wrapper<BizPurchaseOrder> convert2Wrapper);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizPurchaseOrder> queryAllByPage(IPage<BizPurchaseOrder> convert2IPage, @Param("ew") Wrapper<BizPurchaseOrder> convert2Wrapper);

}
