package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 物料采购申请明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@RestController
@RequestMapping("/bizPurchasingApplicationDetails/v1/")
@Api(tags="采购申请明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingApplicationDetailsController extends BaseController<PurchasingApplicationDetailsManager, PurchasingApplicationDetails> {
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<PurchasingApplicationDetails>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<PurchasingApplicationDetails> queryFilter){
        PageList<PurchasingApplicationDetails> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<PurchasingApplicationDetails> selectOne(@RequestParam String id){
        PurchasingApplicationDetails result=baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody PurchasingApplicationDetails entity) {
        String message = "操作成功";
        baseService.saveOrUpdate(entity);

        return new CommonResult<>(true, message);
    }

    /**
     * 根据Excel文件转换数据
     * @param file Excel文件
     */
    @PostMapping("/excelToData")
    @ApiOperation(value = "M-根据Excel文件转换数据")
    public CommonResult<List<PurchasingApplicationDetails>> excelToData(@RequestParam("file") MultipartFile file) throws Exception{
        List<PurchasingApplicationDetails> result = baseService.excelToData(file);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "M-导出数据到Excel",notes = "")
    public CommonResult exportDataToExcel(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<PurchasingApplicationDetails> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

}
