package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationAuditRecordsManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationAuditRecords;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:采购申请审核记录表
 * @Author: Rong Tao
 * @Date: 2024/6/13 16:20
 */
@RestController
@RequestMapping("/purchasingApplicationAuditRecords/v1/")
@Api(tags="采购申请审核记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingApplicationAuditRecordsController extends BaseController<PurchasingApplicationAuditRecordsManager, PurchasingApplicationAuditRecords> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<PurchasingApplicationAuditRecords>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingApplicationAuditRecords> queryFilter) {
        PageList<PurchasingApplicationAuditRecords> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
