package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.ClarifyQuestionsManager;
import com.artfess.cgpt.purchasing.model.ClarifyQuestions;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:澄清提问，有附件
 * @Author: Rong Tao
 * @Date: 2024/6/24 17:21
 */
@RestController
@RequestMapping("/clarifyQuestions/v1/")
@Api(tags="澄清提问")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ClarifyQuestionsController extends BaseController<ClarifyQuestionsManager, ClarifyQuestions> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ClarifyQuestions>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ClarifyQuestions> queryFilter) {
        PageList<ClarifyQuestions> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAndAnswer")
    @ApiOperation(value = "M-分页查询所有数据（包含回答）")
    public CommonResult<PageList<ClarifyQuestions>> pageAndAnswer(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ClarifyQuestions> queryFilter) {
        PageList<ClarifyQuestions> result = baseService.pageAndAnswer(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody ClarifyQuestions entity){
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功");
    }

}
