package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.manager.BizContractMatItemManager;
import com.artfess.cgpt.contract.manager.ContractItemManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.model.BizContractMatItem;
import com.artfess.cgpt.contract.model.ContractItem;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderManager;

import javax.annotation.Resource;
import java.util.List;

/**
 * 采购订单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@RestController
@RequestMapping("/bizPurchaseOrder/v1/")
@Api(tags = "采购订单表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizPurchaseOrderController extends BaseController<BizPurchaseOrderManager, BizPurchaseOrder> {

    @Resource
    private ContractItemManager contractItemManager;

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizPurchaseOrder>> queryAllByPage(@RequestBody QueryFilter<BizPurchaseOrder> queryFilter){
        PageList<BizPurchaseOrder> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizPurchaseOrder> selectOne(@RequestParam("id") String id){
        BizPurchaseOrder result = baseService.getDetailById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeData(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-保存或更新")
    public CommonResult save(@RequestBody BizPurchaseOrder entity) {
        baseService.saveVo(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/pageMatCompanyGroup")
    @ApiOperation(value = "M-分页查询采购商分组")
    public CommonResult<PageList<BizPurchaseOrder>> pageMatCompanyGroup(@RequestBody QueryFilter<BizPurchaseOrder> queryFilter){
        PageList<BizPurchaseOrder> result = baseService.pageMatCompanyGroup(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

//    @PostMapping("/saveRelease")
//    @ApiOperation(value = "M-保存并发布")
//    public CommonResult saveRelease(@RequestBody BizPurchaseOrder entity) {
//        entity.setStatus(2);
//        baseService.saveVo(entity);
//        return new CommonResult<>(true, "操作成功");
//    }

    @PostMapping("/contractDetails")
    @ApiOperation(value = "S-新增订单时供选择合同明细列表")
    public CommonResult<PageList<ContractItem>> findContractdetail(@RequestBody QueryFilter<ContractItem> queryFilter) {
        PageList<ContractItem> result = contractItemManager.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-修改状态")
    public CommonResult confirmOrder(@RequestParam("ids") String ids,@RequestParam("status") String status) {
        baseService.confirmOrder(ids,status);
        return new CommonResult<>(true,"操作成功");
    }

//    @PostMapping("/release")
//    @ApiOperation(value = "M-订单发布")
//    public CommonResult releaseOrder(@RequestParam("id") String id) {
//        baseService.releaseOrder(id);
//        return new CommonResult<>(true,"确认完成");
//    }

}
