package com.artfess.cgpt.project.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDate;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目基本信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-10
 */
@ApiModel(value="ProjectInfo对象", description="项目基本信息表")
@TableName("biz_project_info")
@Data
public class ProjectInfo extends BizModel<ProjectInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目库ID（关联项目台账表ID）")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "申请单编号（自动生成）")
    @TableField("APPLICATION_NUM_")
    private String applicationNum;

    @ApiModelProperty(value = "申请类型（1：标准采购申请，2：固定单价申请，3：其他，如果选择固定单价申请，所有明细数量为1）")
    @TableField("APPLICATION_TYPE_")
    private Integer applicationType;

    @ApiModelProperty(value = "定价方式（1：公开招标，2：询比价，3：限时竞价，4：份额采购（谈判），5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField("PROCUREMENT_METHOD_")
    private Integer procurementMethod;

    @ApiModelProperty(value = "编制人ID")
    @TableField("PREPARED_USER_ID_")
    private String preparedUserId;

    @ApiModelProperty(value = "编制人姓名")
    @TableField("PREPARED_USER_NAME_")
    private String preparedUserName;

    @ApiModelProperty(value = "编制日期")
    @TableField("PREPARED_DATE")
    private LocalDate preparedDate;

    @ApiModelProperty(value = "需求日期")
    @TableField("APPLICATION_DATE_")
    private LocalDate applicationDate;

    @ApiModelProperty(value = "项目编号")
    @TableField("PROJECT_CODE_")
    private String projectCode;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目类型（1.服务，2.设备，3.工程）")
    @TableField("PROJECT_TYPE_")
    private Integer projectType;

    @ApiModelProperty(value = "项目负责人ID")
    @TableField("PROJECT_USER_ID_")
    private String projectUserId;

    @ApiModelProperty(value = "项目负责人姓名")
    @TableField("PROJECT_USER_NAME_")
    private String projectUserName;

    @ApiModelProperty(value = "采购单位ID")
    @TableField("PURCHASING_ORG_ID_")
    private String purchasingOrgId;

    @ApiModelProperty(value = "采购单位编号")
    @TableField("PURCHASING_ORG_CODE_")
    private String purchasingOrgCode;

    @ApiModelProperty(value = "采购单位名称")
    @TableField("PURCHASING_ORG_NAME_")
    private String purchasingOrgName;

    @ApiModelProperty(value = "总投资（万元）")
    @TableField("INVESTMENT_")
    private BigDecimal investment;

    @ApiModelProperty(value = "建设开始时间")
    @TableField("CONSTRUCTION_START_TIME_")
    private LocalDate constructionStartTime;

    @ApiModelProperty(value = "建设结束时间")
    @TableField("CONSTRUCTION_COMPLETION_TIME_")
    private LocalDate constructionCompletionTime;

    @ApiModelProperty(value = "状态（1：草稿，2：审批中，3：已审批，4：已立项，5：流标，" +
            "6：已发中选公示，7：已签订合同，8：驳回），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "项目基本信息明细")
    @TableField(exist = false)
    private List<ProjectInfoDetail> detailList;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
