package com.artfess.cgpt.project.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目采购立项明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-12
 */
@ApiModel(value="ProjectApprovalDetails对象", description="项目采购立项明细表")
@TableName("biz_project_approval_details")
@Data
public class ProjectApprovalDetails extends BizModel<ProjectApprovalDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID（关联项目立项表ID）")
    @TableField("NOTICE_ID_")
        private String noticeId;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "明细来源类型（1.项目库引入，2.项目申请引入，3.手工添加，4.自动生成），默认1，默认1")
    @TableField("PROJECT_SOURCE_TYPE_")
    private Integer projectSourceType;

    @ApiModelProperty(value = "项目申请ID（关联项目申请表ID）")
    @TableField("PROJECT_INFO_ID_")
    private String projectInfoId;

    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "明细类型（1.服务，2.工程，3.设备）")
    @TableField("DETAIL_TYPE_")
    private Integer detailType;

    @ApiModelProperty(value = "报价轮数（默认1）")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;

    @ApiModelProperty(value = "对应明细id（如引入申请为申请明细id，服务类则是服务项目明细表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类编号，关联物料分类CODE")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "名称（服务类：名称，工程类：项目或费用名称）")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号（图号）")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "计划价格（合计金额）")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展（服务范围）")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展（服务内容）")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "物料状态（1：未评标，2：已评标，3：已定标，4：已发送成交通知 ，5：已中标，6：流标）")
    @TableField("BID_STATUS_")
    private Integer bidStatus;

    @ApiModelProperty(value = "最高限价")
    @TableField("MAXIMUM_PRICE_LIMIT_")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "服务开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "服务结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField("BUILDING_AREA_")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField("CONSTRUCTION_ENGINEERING_")
    private BigDecimal constructionEngineering;

    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField("EQUIPMENT_PROCUREMENT_")
    private BigDecimal equipmentProcurement;

    @ApiModelProperty(value = "其他费用(万元)")
    @TableField("OTHER_EXPENSES_")
    private BigDecimal otherExpenses;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField("EQUIPMENT_CLASSIFICATION_")
    private Integer equipmentClassification;

    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField("TECHNICAL_REQUIREMENT_")
    private String technicalRequirement;

    @ApiModelProperty(value = "不含税单价（元）")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税总额（元）")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税单价（元）")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税总额（元）")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "备注（企业补充说明）")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "当前最低报价")
    @TableField(exist = false)
    private BigDecimal minQuoPrice;

    @ApiModelProperty(value = "我的报价（单价）")
    @TableField(exist = false)
    private BigDecimal myPrice;
    @ApiModelProperty(value = "我的报价（总额）")
    @TableField(exist = false)
    private BigDecimal myAmount;

    @ApiModelProperty(value = "报价公司id")
    @TableField(exist = false)
    private String quoCompanyId;
    @ApiModelProperty(value = "报价公司编号")
    @TableField(exist = false)
    private String quoCompanyCode;
    @ApiModelProperty(value = "报价公司名称")
    @TableField(exist = false)
    private String quoCompanyName;

    @ApiModelProperty(value = "报价模版明细数据")
    @TableField(exist = false)
    private List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;

    @ApiModelProperty(value = "投标补充说明")
    @TableField(exist = false)
    private String tenderExplain;

    @ApiModelProperty(value = "报价模版明细")
    @TableField(exist = false)
    private List<QuotationTemplateDetail> quotationTemplateDetailList;

    @ApiModelProperty(value = "报价排名（由低到高）")
    @TableField(exist = false)
    private Integer rank;

    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField("PROJECT_STATUS_")
    private Integer projectStatus;

    @ApiModelProperty(value = "项目描述")
    @TableField("PROJECT_DESCRIPT_")
    private String projectDescript;

    @ApiModelProperty(value = "责任人ID")
    @TableField("PERSON_LIABLE_ID_")
    private String personLiableId;

    @ApiModelProperty(value = "责任人姓名")
    @TableField("PERSON_LIABLE_NAME_")
    private String personLiableName;

    @ApiModelProperty(value = "责任人联系方式")
    @TableField("PERSON_LIABLE_PHONE_")
    private String personLiablePhone;

    @ApiModelProperty(value = "评标状态（0.未评标，1.已评标）")
    @TableField(exist = false)
    private Integer isEva;

    @ApiModelProperty(value = "付款信息集合")
    @TableField(exist = false)
    private List<ProjectApprovalPay> payInfoList;

    @ApiModelProperty(value = "保证金（元）")
    @TableField("BOND_")
    private BigDecimal bond;

}
