package com.artfess.cgpt.project.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.project.manager.ProjectInfoDetailManager;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.dao.ProjectInfoDao;
import com.artfess.cgpt.project.manager.ProjectInfoManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.project.model.ProjectInfoDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.List;

/**
 * 项目基本信息表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-10
 */
@Service
public class ProjectInfoManagerImpl extends BaseManagerImpl<ProjectInfoDao, ProjectInfo> implements ProjectInfoManager {

    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ProjectInfoDetailManager detailManager;
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<ProjectInfo> queryAllByPage(QueryFilter<ProjectInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<ProjectInfo> result = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<ProjectInfo> queryByPage(QueryFilter<ProjectInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        queryFilter.addFilter("PURCHASING_ORG_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        IPage<ProjectInfo> result = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public ProjectInfo getDataById(String id) {
        ProjectInfo result = super.getById(id);

        LambdaQueryWrapper<ProjectInfoDetail> detailQW = new LambdaQueryWrapper<>();
        detailQW.eq(ProjectInfoDetail::getProjectInfoId,id);
        result.setDetailList(detailManager.list(detailQW));
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));

        return result;
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper<ProjectInfoDetail> detailQW = new LambdaQueryWrapper<>();
        detailQW.in(ProjectInfoDetail::getProjectInfoId,ids);
        detailManager.remove(detailQW);

        accessoryService.removeBySourceIds(ids);

        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(ProjectInfo entity) {
        List<ProjectInfoDetail> detailList = entity.getDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtil.isEmpty(entity.getId())){
            //新增
            entity.setPreparedUserId(ContextUtil.getCurrentUserId());
            entity.setPreparedUserName(ContextUtil.getCurrentUserName());
            entity.setPreparedDate(LocalDate.now());

            if(BeanUtils.isEmpty(entity.getApplicationNum())){
                //生成编号
                entity.setApplicationNum(BizUtils.getNextSerialNumber(systemConfigFeignService, "cgsq_sqdbh"));
            }
        }else {
            //先清除已有明细
            LambdaQueryWrapper<ProjectInfoDetail> detailQW = new LambdaQueryWrapper<>();
            detailQW.eq(ProjectInfoDetail::getProjectInfoId,entity.getId());
            detailManager.remove(detailQW);

            accessoryService.removeBySourceId(entity.getId());
        }
        super.saveOrUpdate(entity);

        //保存明细
        if(BeanUtil.isNotEmpty(detailList) && detailList.size()>0){
            detailList.stream().forEach(s->{
                s.setProjectInfoId(entity.getId());
            });
            detailManager.saveBatch(detailList);
        }

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

    }

}
