package com.artfess.cgpt.project.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BidEvaluationRecordManager;
import com.artfess.cgpt.bidding.manager.BiddingQuotationTemplateDetailDataManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.QuotationTemplateDetailManager;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.ProjectApprovalPayManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.project.dao.ProjectApprovalDetailsDao;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.project.model.ProjectApprovalPay;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.ProjectEvaluationExpert;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目采购立项明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
@Service
public class ProjectApprovalDetailsManagerImpl extends BaseManagerImpl<ProjectApprovalDetailsDao, ProjectApprovalDetails> implements ProjectApprovalDetailsManager {

    @Autowired
    BizBiddingQuotationManager quotationManager;
    @Autowired
    private ProjectApprovalManager approvalManager;
    @Autowired
    TenderDocumentManager tenderDocumentManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private QuotationTemplateDetailManager quotationTemplateDetailManager;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager biddingQuotationTemplateDetailDataManager;
    @Autowired
    private BidEvaluationRecordManager evaluationRecordManager;
    @Autowired
    private ProjectApprovalPayManager payInfoManager;

    @Override
    public PageList<ProjectApprovalDetails> queryAllByPage(QueryFilter<ProjectApprovalDetails> queryFilter) {
//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<ProjectApprovalDetails> result = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));

        List<ProjectApprovalDetails> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(ProjectApprovalDetails temp : records){
                LambdaQueryWrapper<ProjectApprovalPay> payInfoQW = new LambdaQueryWrapper<>();
                payInfoQW.eq(ProjectApprovalPay::getNoticeDetailId,temp.getId());
                temp.setPayInfoList(payInfoManager.list(payInfoQW));
            }
        }

        return new PageList<>(result);
    }

    @Override
    public ProjectApprovalDetails getDataById(String id) {
        ProjectApprovalDetails result = super.getById(id);
        LambdaQueryWrapper<ProjectApprovalPay> payInfoQW = new LambdaQueryWrapper<>();
        payInfoQW.eq(ProjectApprovalPay::getNoticeDetailId,id);
        result.setPayInfoList(payInfoManager.list(payInfoQW));
        return result;
    }


    @Override
    public ProjectApproval quoData(QueryFilter<ProjectApprovalDetails> queryFilter) {
        String noticeId = null;
        Integer round = 1;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }

        ProjectApproval notice = approvalManager.getById(noticeId);
        round = notice.getQuotationRoundsNum();

        //查询招标/补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
//                .eq(TenderDocument::getProjectApprovalType,2)
//                .isNotNull(TenderDocument::getType)
//                .eq(TenderDocument::getIsDele,"0");
//        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
//
//        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
//            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
//
//            //招标文件
//            List<TenderDocument> zbDocument = collect.get(1);
//            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
//                TenderDocument tenderDocument = zbDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setZbDocument(tenderDocument);
//            }
//
//            //补遗文件
//            List<TenderDocument> byDocument = collect.get(2);
//            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
//                byDocument.forEach(s->s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId())));
//                notice.setByDocument(byDocument);
//            }
//
//        }

        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<ProjectApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //获取每个明细id和最低报价
//        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, round,"2");

        if(BeanUtil.isNotEmpty(records) && records.size()>0){
            //查询付款信息
            LambdaQueryWrapper<ProjectApprovalPay> payInfoQW = new LambdaQueryWrapper<>();
            payInfoQW.eq(ProjectApprovalPay::getNoticeId,notice.getId());
            List<ProjectApprovalPay> payInfoList = payInfoManager.list(payInfoQW);

            for(ProjectApprovalDetails hd : records){
                String hId = hd.getId();
                //获取报价表中当前用户的报价
                LambdaQueryWrapper<BizBiddingQuotation> quoQW= new LambdaQueryWrapper<>();
                quoQW.eq(BizBiddingQuotation::getNoticeDetailedId,hId)
                        .eq(BizBiddingQuotation::getNoticeType,"2")
                        .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
                        .orderByAsc(BizBiddingQuotation::getQuotationTime);
                List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);

                //查询报价模版明细
                LambdaQueryWrapper<QuotationTemplateDetail> quoTemplateQW = new LambdaQueryWrapper<>();
                quoTemplateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
                        .eq(QuotationTemplateDetail::getIsDele,"0");
                List<QuotationTemplateDetail> quotationTemplateDetails = quotationTemplateDetailManager.list(quoTemplateQW);

                if(BeanUtils.isNotEmpty(quoList) && quoList.size()>0){
                    int r = 1;
                    for(BizBiddingQuotation quotation : quoList){
                        LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                        templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,quotation.getId());
                        List<BiddingQuotationTemplateDetailData> templateDataList = biddingQuotationTemplateDetailDataManager.list(templateDataQW);

                        if(quotation.getQuotationRounds().equals(round)){
                            //如果报价为当前轮次
                            if(BeanUtils.isNotEmpty(quotation.getQuotationPrice())){
                                hd.setMyPrice(quotation.getQuotationPrice());
                            }
                            if(BeanUtils.isNotEmpty(quotation.getTenderExplain())){
                                hd.setTenderExplain(quotation.getTenderExplain());
                            }

                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    temp.setValue(collect.get(0));
                                }
                            }
                        }else {
                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    if(r==1){
                                        temp.setQuoValue1(collect.get(0));
                                    }else if(r==2){
                                        temp.setQuoValue2(collect.get(0));
                                    }else if(r==3){
                                        temp.setQuoValue3(collect.get(0));
                                    }else if(r==4){
                                        temp.setQuoValue4(collect.get(0));
                                    }else {
                                        temp.setValue(collect.get(0));
                                    }
                                }
                            }
                        }
                        r++;
                    }
                }

                if(notice.getProcureType()==3){
                    List<BizBiddingQuotation> rankList = quotationManager.getRankList(noticeId, hId, String.valueOf(notice.getQuotationRoundsNum()), "1");
                    //判断该详细在报价表里是否有报价
                    if(BeanUtils.isNotEmpty(rankList) && rankList.size()>0) {
                        hd.setMinQuoPrice(rankList.get(0).getQuotationPrice());
                        //设置当前报价排名
                        if(BeanUtils.isNotEmpty(hd.getMyPrice())){
                            Integer rank = rankList.stream().filter(s -> s.getQuotationCompanyId().equals(ContextUtil.getCurrentOrgId()) && s.getQuotationPrice().compareTo(hd.getMyPrice()) == 0)
                                    .map(s -> s.getRank()).collect(Collectors.toList()).get(0);
                            hd.setRank(rank);
                        }
                    }
                }
                hd.setQuotationTemplateDetailList(quotationTemplateDetails);

                if(BeanUtils.isNotEmpty(payInfoList) && payInfoList.size()>0){
                    List<ProjectApprovalPay> collect = payInfoList.stream().filter(s -> s.getNoticeDetailId().equals(hd.getId())).collect(Collectors.toList());
                    hd.setPayInfoList(collect);
                }
            }
        }

        notice.setDetailsList(records);

        return notice;
    }

    @Override
    public ProjectApproval quoManageData(QueryFilter<ProjectApprovalDetails> queryFilter) {
        String noticeId = null;
        String round = "1";
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        ProjectApproval notice = approvalManager.getById(noticeId);

        //查询招标/补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
//                .eq(TenderDocument::getProjectApprovalType,1)
//                .isNotNull(TenderDocument::getType)
//                .eq(TenderDocument::getIsDele,"0");
//        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
//
//        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
//            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
//
//            //招标文件
//            List<TenderDocument> zbDocument = collect.get(1);
//            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
//                TenderDocument tenderDocument = zbDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setZbDocument(tenderDocument);
//            }
//
//            //补遗文件
//            List<TenderDocument> byDocument = collect.get(2);
//            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
//                TenderDocument tenderDocument = byDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setByDocument(tenderDocument);
//            }
//
//        }

        List<ProjectApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //获取每个明细id和最低报价
        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, round,"2");

        if(BeanUtil.isNotEmpty(records) && records.size()>0){
            //查询付款信息
            LambdaQueryWrapper<ProjectApprovalPay> payInfoQW = new LambdaQueryWrapper<>();
            payInfoQW.eq(ProjectApprovalPay::getNoticeId,notice.getId());
            List<ProjectApprovalPay> payInfoList = payInfoManager.list(payInfoQW);
            for(ProjectApprovalDetails hd : records){
                if(BeanUtils.isNotEmpty(payInfoList) && payInfoList.size()>0){
                    List<ProjectApprovalPay> collect = payInfoList.stream().filter(s -> s.getNoticeDetailId().equals(hd.getId())).collect(Collectors.toList());
                    hd.setPayInfoList(collect);
                }

                String hId = hd.getId();
                //判断该详细在报价表里是否有报价
                if(groupMinPrice.containsKey(hId)){
                    Map<String, String> map = groupMinPrice.get(hId);
                    String minPrice = String.valueOf(map.get("minPrice"));
                    if(BeanUtils.isNotEmpty(minPrice)) hd.setMinQuoPrice(new BigDecimal(minPrice));
//                    hd.setMinQuoPrice(BeanUtil.isNotEmpty(minPrice)
//                            ?new BigDecimal(minPrice): BigDecimal.ZERO);
                }
//                else {
//                    hd.setMinQuoPrice(BigDecimal.ZERO);
//                }
            }
        }

        notice.setDetailsList(records);
        return notice;
    }

    @Override
    public PageList<ProjectApprovalDetails> bidOpenManageData(QueryFilter<ProjectApprovalDetails> queryFilter) {
        queryFilter.addFilter("quo.NOTICE_TYPE_","2", QueryOP.EQUAL);
        IPage<ProjectApprovalDetails> result = baseMapper.quoDataQuery(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass()));

        return new PageList<>(result);
    }

    @Override
    public void exportTemplateToExcel(QueryFilter<ProjectApprovalDetails> queryFilter, HttpServletResponse response) throws Exception {
        String noticeId = null;
        String round = "1";
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        ProjectApproval notice = approvalManager.getById(noticeId);
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<ProjectApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //查询报价模版
        LambdaQueryWrapper<QuotationTemplateDetail> templateQW = new LambdaQueryWrapper<>();
        templateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
                .eq(QuotationTemplateDetail::getIsDele,"0");
        List<QuotationTemplateDetail> quoTemplateDetail = quotationTemplateDetailManager.list(templateQW);


        if(BeanUtils.isEmpty(records) || records.size()<=0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        List<Map<String,Object>> dataMapList = new ArrayList<>();
        records.forEach(s->{
            Map<String,Object> dataMap = new HashMap<>();
            dataMap.put("detailId",s.getId());
            dataMap.put("matName",s.getMatName());
            if(notice.getApplicationType()!=1){
                dataMap.put("matSpec",s.getMatSpec());
            }
            dataMap.put("baseExt",s.getMatBaseExt());
            dataMap.put("otherExt",s.getMatOtherExt());
            dataMap.put("serviceStartTime",s.getServiceStartTime());
            dataMap.put("serviceEndTime",s.getServiceEndTime());

            if(notice.getApplicationType()!=1){
                dataMap.put("technicalRequirement",s.getTechnicalRequirement());
                dataMap.put("personLiableName",s.getPersonLiableName());
                dataMap.put("plannedPrice",s.getPlannedPrice());
                dataMap.put("matCompanyName",s.getMatCompanyName());
                dataMap.put("maximumPriceLimit",s.getMaximumPriceLimit());
            }

            dataMap.put("companyRemarks",s.getRemarks());

            dataMapList.add(dataMap);
        });

        String fileName = "报价导入模版";

        //必填列
        List<String> requiredList = new ArrayList<>();
        //输入列
        List<String> inputList = new ArrayList<>();
        //需要转换格式的列，值为1代表转数值
        HashMap<String, Integer> formatMap = new HashMap<>();

        Map<String, String> exportMaps = new LinkedHashMap<>();
        exportMaps.put("detailId","标的ID");
        exportMaps.put("matName","名称");
        if(notice.getApplicationType()!=1){
            exportMaps.put("matSpec","规格型号/图号");
        }
        exportMaps.put("baseExt","服务范围");
        exportMaps.put("otherExt","服务内容");
        exportMaps.put("serviceStartTime","服务开始时间");
        exportMaps.put("serviceEndTime","服务结束时间");

        if(notice.getApplicationType()!=1){
            exportMaps.put("technicalRequirement","技术要求");
            exportMaps.put("personLiableName","责任人");
            exportMaps.put("plannedPrice","计划价格");
            exportMaps.put("matCompanyName","需求单位");
            exportMaps.put("maximumPriceLimit","最高限价");
        }

        exportMaps.put("companyRemarks","备注");

//        exportMaps.put("isQuo","是否报价");
//        inputList.add("isQuo");
//        requiredList.add("isQuo");

        quoTemplateDetail.forEach(s->{
            if(s.getThrowEntry().equals(true)){
                exportMaps.put(s.getId(),s.getQuoArrange());
                inputList.add(s.getId());
            }
            if(s.getIsRequired().equals(true)){
                requiredList.add(s.getId());
            }
            if(s.getPriceEntry()==1){
                formatMap.put(s.getId(),1);
            }
        });
        exportMaps.put("quoRemarks","投标补充说明");
        inputList.add("quoRemarks");

        // 导出下载excel文件
        HSSFWorkbook workbook = ExcelUtil.exportExcel(fileName, 24, exportMaps, dataMapList, 1,notice.getNoticeTitle()+"（黄底色为必填项，蓝底色为可填项）",requiredList,inputList,formatMap,7);

        ExcelUtil.downloadExcel(workbook, fileName, response);

    }

    @Override
    public List<Map<String, String>> excelTemplateToData(MultipartFile file) {
        List<Map<String, String>> maps = ExcelUtil.ImportDate(file,false,1);

        if(BeanUtils.isNotEmpty(maps) && maps.size()>0){
            for(Map<String, String> map : maps){
                String dataId = map.get("标的ID");
                map.forEach((key,value)->{
                    if(key.contains("元") || key.contains("单价")){
                        try {
                            if(BeanUtils.isNotEmpty(value)){
                                new BigDecimal(value);
                            }
                        } catch (Exception e){
                            String errMes = "";
                            if(BeanUtils.isNotEmpty(dataId)){
                                errMes = "标的ID【"+dataId+"】";
                            }
                            System.out.println("请修正"+errMes+"列【"+key+"】数据【"+value+"】格式为数值型");
                            throw new BaseException("请修正"+errMes+"列【"+key+"】数据【"+value+"】格式为数值型");
                        }
                    }
                });
            }

        }

        return maps;
    }

    @Override
    public PageList<ProjectApprovalDetails> pageEvaDetail(QueryFilter<ProjectApprovalDetails> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        IPage<ProjectApprovalDetails> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<ProjectApprovalDetails> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(ProjectApprovalDetails temp : records){
                //查询是否评标
                LambdaQueryWrapper<BidEvaluationRecord> evaRecordQW = new LambdaQueryWrapper<>();
                evaRecordQW.eq(BidEvaluationRecord::getNoticeId,temp.getNoticeId())
                        .eq(BidEvaluationRecord::getNoticeDetailedId,temp.getId())
                        .eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                        .eq(BidEvaluationRecord::getStatus,2);
                if(evaluationRecordManager.count(evaRecordQW)>0){
                    temp.setIsEva(1);
                }else {
                    temp.setIsEva(0);
                }

            }
        }

        return new PageList<>(result);
    }

}
