package com.artfess.cgpt.project.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.ProjectLedger;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:14
 */
public interface ProjectLedgerManager extends BaseManager<ProjectLedger> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ProjectLedger> queryAllByPage(QueryFilter<ProjectLedger> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(ProjectLedger entity);

    /**
     * 批量删除
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    ProjectLedger getDataById(String id);

}
