package com.artfess.cgpt.project.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.purchasing.model.MatApproval;

import java.util.List;

/**
 * 物料/项目采购立项表，物料和项目采购立项主表都走此表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
public interface ProjectApprovalManager extends BaseManager<ProjectApproval> {

    PageList<ProjectApproval> queryAllByPage(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 根据id集合删除数据
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    ProjectApproval getDataById(String id);

    /**
     * 保存或更新数据
     * @param entity
     */
    ProjectApproval saveOrUpdateEntity(ProjectApproval entity);

    /**
     * 上传补遗文件
     * @param entity
     */
    void uploadTenderDoc(ProjectApproval entity);

    /**
     * 修改项目状态
     * @param ids
     * @param status
     */
    void modifyBidStatus(String ids,String status);

    /**
     * 修改发布状态
     * @param ids
     * @param status
     */
    void modifyReleaseStatus(String ids,String status);

    /**
     * 修改定标状态
     * @param ids
     * @param status
     */
    void modifyCalibraStatus(String ids,String status);

    /**
     * 参与报名-立项分页查询
     * @param queryFilter
     * @return
     */
    PageList<ProjectApproval> signData(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 我的报价-分页查询
     * @param queryFilter
     * @return
     */
    PageList<ProjectApproval> quoData(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 报价管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<ProjectApproval> quoManageData(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 开标管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<ProjectApproval> bidOpenData(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 开标管理-开标
     * @param entity
     */
    void openingBid(ProjectApproval entity);

    /**
     * 开标管理-发起新一轮报价
     * @param entity
     */
    void newRoundQuo(ProjectApproval entity);

    /**
     * 评标管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<ProjectApproval> bidEvaData(QueryFilter<ProjectApproval> queryFilter);

    /**
     * 成交通知-发布
     * @param id
     * @return
     */
    void releaseWinBidNotice(String id) throws Exception;

    /**
     * 根据id和用户查询详情（公告及相关文件）
     * @param id
     * @param userId
     * @return
     */
    ProjectApproval getInfoByIdAndUserId(String id,String userId);

}
