package com.artfess.cgpt.project.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 项目采购立项明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
public interface ProjectApprovalDetailsManager extends BaseManager<ProjectApprovalDetails> {

    PageList<ProjectApprovalDetails> queryAllByPage(QueryFilter<ProjectApprovalDetails> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    ProjectApprovalDetails getDataById(String id);

    /**
     * 报价明细
     * @param queryFilter
     * @return
     */
    ProjectApproval quoData(QueryFilter<ProjectApprovalDetails> queryFilter);

    /**
     * 报价管理-明细
     * @param queryFilter
     * @return
     */
    ProjectApproval quoManageData(QueryFilter<ProjectApprovalDetails> queryFilter);

    /**
     * 开票管理-报价明细
     * @param queryFilter
     * @return
     */
    PageList<ProjectApprovalDetails> bidOpenManageData(QueryFilter<ProjectApprovalDetails> queryFilter);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportTemplateToExcel(QueryFilter<ProjectApprovalDetails> queryFilter, HttpServletResponse response) throws Exception;

    /**
     * 根据Excel文件转换数据（报价模版导入）
     * @param file 文件
     * @throws Exception
     */
    List<Map<String, String>> excelTemplateToData(MultipartFile file);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ProjectApprovalDetails> pageEvaDetail(QueryFilter<ProjectApprovalDetails> queryFilter);

}
