package com.artfess.cgpt.project.dao;

import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * 项目采购立项明细表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
public interface ProjectApprovalDetailsDao extends BaseMapper<ProjectApprovalDetails> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<ProjectApprovalDetails> queryAllByPage(IPage<ProjectApprovalDetails> convert2IPage, @Param("ew")Wrapper<ProjectApprovalDetails> convert2Wrapper);

    /**
     * 分页查询报价公司明细
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<ProjectApprovalDetails> quoDataQuery(IPage<ProjectApprovalDetails> convert2IPage, @Param("ew") Wrapper<ProjectApprovalDetails> convert2Wrapper);

}
