package com.artfess.cgpt.project.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.manager.ProjectInfoManager;

import java.util.List;

/**
 * 项目基本信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-10
 */
@RestController
@RequestMapping("/projectInfo/v1/")
@Api(tags="项目基本信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectInfoController extends BaseController<ProjectInfoManager, ProjectInfo> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询当前公司数据")
    public CommonResult<PageList<ProjectInfo>> queryByPage(@RequestBody QueryFilter<ProjectInfo> queryFilter) {
        PageList<ProjectInfo> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ProjectInfo>> queryAllByPage(@RequestBody QueryFilter<ProjectInfo> queryFilter) {
        PageList<ProjectInfo> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<ProjectInfo> getDataById(@RequestParam("id") String id) {
        ProjectInfo result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除")
    public CommonResult remove(@RequestBody List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新")
    public CommonResult saveOrUpdate(@RequestBody ProjectInfo entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

}
