package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.EquipmentProjectDetailManager;
import com.artfess.cgpt.project.model.EquipmentProjectDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:设备项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:24
 */
@RestController
@RequestMapping("/equipmentProjectDetail/v1/")
@Api(tags="设备项目明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class EquipmentProjectDetailController extends BaseController<EquipmentProjectDetailManager, EquipmentProjectDetail> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<EquipmentProjectDetail>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<EquipmentProjectDetail> queryFilter) {
        PageList<EquipmentProjectDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}