package com.artfess.cgpt.order.controller;


import cn.hutool.json.JSONObject;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;

import java.util.List;

/**
 * 订单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@RestController
@RequestMapping("/bizRegistrationOrder/v1/")
public class BizRegistrationOrderController extends BaseController<BizRegistrationOrderManager, BizRegistrationOrder> {
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizRegistrationOrder>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizRegistrationOrder> queryFilter){
        PageList<BizRegistrationOrder> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizRegistrationOrder> selectOne(@RequestParam String id){
        BizRegistrationOrder result=baseService.getDetailById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizRegistrationOrder entity) {
        String message = "操作成功";
        baseService.saveVo(entity);
        return new CommonResult<>(true, message);
    }

    /**
     * 查询当前公司余额
     * @return
     */
    @ApiOperation(value = "M-获取当前公司余额（支付平台）")
    @PostMapping("/getCurrentAccount")
    public CommonResult<JSONObject> getCurrentAccount() {
        JSONObject result = baseService.getCurrentAccount();
        return new CommonResult(true, "查询成功", result);
    }

    /**
     * 付款（支付平台）
     * @param trans 支付记录
     * @return
     */
    @ApiOperation(value = "M-付款（支付平台）",notes = "支付记录对象")
    @PostMapping("/payByBalance")
    public CommonResult payByBalance(@RequestBody BizRegistrationOrder trans) {
        baseService.payByBalance(trans);
        return new CommonResult(true, "支付成功");
    }

}
