package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @Description:产品管理表
 * @Author: Rong Tao
 * @Date: 2024/8/12 15:02
 */
@ApiModel(value="Product对象", description="产品管理表")
@Data
@TableName("biz_product")
public class Product extends BizModel<Product> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "组织编号")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "商品编号")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "商品名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "规格型号")
    @TableField("SPEC_")
    private String spec;

    @ApiModelProperty(value = "计量单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "品牌")
    @TableField("BRAND_")
    private String brand;

    @ApiModelProperty(value = "描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "状态（0.禁用，1.启用），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已审核，2：审核中）")
    @TableField("AUDIT_STATUS_")
    private Integer auditStatus;

    @ApiModelProperty(value = "产品生效日期")
    @TableField("START_DATE_")
    private LocalDate startDate;

    @ApiModelProperty(value = "产品失效日期")
    @TableField("END_DATE_")
    private LocalDate endDate;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<ProductDetail> detailList;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
