package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 
 * 物料分类
 * @company 阿特菲斯信息技术有限公司
 * @author rong tao
 * @since 2023-12-22
 */
@ApiModel(value="BizMaterialCategory对象", description="物料分类")
@Data
@TableName("biz_material_category")
public class BizMaterialCategory extends BizModel<BizMaterialCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "父级ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "父级CODE")
    @TableField("PARENT_CODE_")
    private String parentCode;

    @ApiModelProperty(value = "分类编号")
    @TableField("CODE_")
    @Excel(name = "分类编号")
    private String code;

    @ApiModelProperty(value = "分类名称")
    @TableField("NAME_")
    @Excel(name = "分类名称")
    private String name;

    @ApiModelProperty(value = "全路径ID，使用点隔开")
    @TableField("PATH_ID_")
    private String pathId;

    @ApiModelProperty(value = "全路径CODE，使用/隔开")
    @TableField("PATH_CODE_")
    private String pathCode;

    @ApiModelProperty(value = "系统标识，默认值cgpt")
    @TableField("SYSTEM_CODE_")
    private String systemCode;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYSTEM_NAME_")
    private String systemName;

    @ApiModelProperty(value = "渝企采分类编码")
    @TableField("YQC_CATEGORY_CODE_")
    @Excel(name = "渝企采分类编码")
    private String yqcCategoryCode;

    @ApiModelProperty(value = "渝企采分类名称")
    @TableField("YQC_CATEGORY_NAME_")
    @Excel(name = "渝企采分类名称")
    private String yqcCategoryName;

    @ApiModelProperty(value = "状态（0：禁用，1：启用）")
    @TableField("STATUS_")
    @Excel(name = "状态(0:禁用,1:启用)")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("NOTES_")
    private String notes;

    @ApiModelProperty(value = "排序号（自动生成）")
    @TableField("SN_")
    private Long sn;

    @ApiModelProperty(value = "全路径NAME，使用/隔开")
    @TableField("PATH_NAME_")
    private String pathName;

    @ApiModelProperty(value = "是否有子节点（0：否，1：是）")
    @TableField("HAS_CHILDREN_")
    private Integer hasChildren;

    @TableField(exist = false)
    @ApiModelProperty(value = "子类")
    private List<BizMaterialCategory> children;

}
