package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 企业物料库
 *
 * @company 阿特菲斯信息技术有限公司
 * @author rong tao
 * @since 2023-12-22
 */
@ApiModel(value="BizMaterial对象", description="企业物料库")
@Data
@TableName("biz_material")
public class BizMaterial extends BizModel<BizMaterial> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "物料分类编号，关联物料分类CODE")
    @TableField("MAT_CATEGORY_")
    @Excel(name = "物料分类")
    private String matCategory;

    @ApiModelProperty(value = "企业物料编号")
    @TableField("MAT_CODE_")
    @Excel(name = "企业物料编号")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    @Excel(name = "平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    @Excel(name = "物料名称")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    @Excel(name = "物料牌号")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号（图号）")
    @TableField("MAT_SPEC_")
    @Excel(name = "规格型号")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    @Excel(name = "计量单位")
    private String matUnit;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    @Excel(name = "品牌")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    @Excel(name = "基础扩展")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    @Excel(name = "其他扩展")
    private String matOtherExt;

    @ApiModelProperty(value = "税率")
    @TableField("MAT_TAXRATE_")
    @Excel(name = "税率(%)")
    private Integer matTaxrate;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    @Excel(name = "是否采购(0:自采,1:集采)")
    private Integer matIfPlat;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已审核，审核中）")
    @TableField("AUDIT_STATUS_")
    private String auditStatus;

    @ApiModelProperty(value = "启用状态（0：禁用，1：启用）")
    @TableField("MAT_STATUS_")
    @Excel(name = "状态(0:禁用,1:启用)")
    private Integer matStatus;

    @ApiModelProperty(value = "同步时间")
    @TableField("MAT_TRANSFER_TIME_")
    private LocalDateTime matTransferTime;


    @ApiModelProperty(value = "物资类型（1.物资，2.设备），默认1")
    @TableField("MAT_TYPE_")
    private Integer matType;

    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField("EQUIPMENT_CLASSIFICATION_")
    private Integer equipmentClassification;

    @ApiModelProperty(value = "数量（设备使用）")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField("TECHNICAL_REQUIREMENT_")
    private String technicalRequirement;

    @ApiModelProperty(value = "不含税单价（元）")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税总额（元）")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税单价（元）")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税总额（元）")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

}
