package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.dao.PlatMaterialDao;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/25 18:33
 */
@Service
public class PlatMaterialManagerImpl extends BaseManagerImpl<PlatMaterialDao, PlatMaterial> implements PlatMaterialManager {

    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private BizMaterialManager materialManager;

    @Override
    public PageList<PlatMaterial> queryAllByPage(QueryFilter<PlatMaterial> queryFilter) {
        IPage<PlatMaterial> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void updateMatStatus(List<String> ids, String status) {
        List<PlatMaterial> platMaterials = super.listByIds(ids);
        List<String> platCodes = platMaterials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());

        //启用状态（0：禁用，1：启用）
        if(status.equals("0")){
            //如果是禁用
            //1.查询采购申请明细是否存在该物料的数据
            QueryWrapper<PurchasingApplicationDetails> applicationDetailQW = new QueryWrapper<>();
            applicationDetailQW.select("DISTINCT MAT_PLATCODE_")
                    .lambda().in(PurchasingApplicationDetails::getMatPlatcode,platCodes);
            List<Object> objList = applicationDetailsManager.listObjs(applicationDetailQW);

            //如果存在，不能禁用
            if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
                List<String> matPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("平台物料编号【"+String.join(",",matPlatCodes)+"】已有关联数据，无法禁用");
            }
        }

        //2.修改平台物料状态
        LambdaUpdateWrapper<PlatMaterial> platMaterialUW = new LambdaUpdateWrapper<>();
        platMaterialUW.set(PlatMaterial::getMatStatus,status)
                .in(PlatMaterial::getId,ids)
                .eq(PlatMaterial::getIsDele,"0");
        super.update(platMaterialUW);

        //3.修改企业物料状态
        LambdaUpdateWrapper<BizMaterial> materialUW = new LambdaUpdateWrapper<>();
        materialUW.set(BizMaterial::getMatStatus,status)
                .in(BizMaterial::getMatPlatcode,platCodes)
                .eq(BizMaterial::getIsDele,"0");
        materialManager.update(materialUW);

    }

    @Override
    @Transactional
    public void updateMatCategory(List<String> ids, String categoryCode) {
        List<PlatMaterial> platMaterials = super.listByIds(ids);
        List<String> platCodes = platMaterials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());
        //修改平台物料分类
        LambdaUpdateWrapper<PlatMaterial> platMaterialUW = new LambdaUpdateWrapper<>();
        platMaterialUW.set(PlatMaterial::getMatCategory,categoryCode)
                .in(PlatMaterial::getId,ids)
//                .eq(PlatMaterial::getMatStatus,1)
                .eq(PlatMaterial::getIsDele,"0");
        super.update(platMaterialUW);

        //修改企业物料分类
        LambdaUpdateWrapper<BizMaterial> materialUW = new LambdaUpdateWrapper<>();
        materialUW.set(BizMaterial::getMatCategory,categoryCode)
                .in(BizMaterial::getMatPlatcode,platCodes)
//                .eq(BizMaterial::getMatStatus,1)
                .eq(BizMaterial::getIsDele,"0");
        materialManager.update(materialUW);

    }

    @Override
    public void exportExcelData(QueryFilter<PlatMaterial> queryFilter, HttpServletResponse response) throws IOException {
//        queryFilter.setPageBean(new PageBean(0, -1, false));
        PageList<PlatMaterial> bizMaterialPageList = queryAllByPage(queryFilter);
        List<PlatMaterial> data=bizMaterialPageList.getRows();

        String fileName = "平台物料-导出数据";

        if (null == data || data.size() == 0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置s
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, PlatMaterial.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }


}
