package com.artfess.cgpt.material.manager.impl;

import com.artfess.cgpt.material.model.MaterialHierarchicalManagementRange;
import com.artfess.cgpt.material.dao.MaterialHierarchicalManagementRangeDao;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementRangeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 物料分级管理应用企业表（查询时需要结合物料分级管理表中创建企业进行联合判断，默认创建企业就不添加到表格中来） 服务实现类
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@Service
public class MaterialHierarchicalManagementRangeManagerImpl extends BaseManagerImpl<MaterialHierarchicalManagementRangeDao, MaterialHierarchicalManagementRange> implements MaterialHierarchicalManagementRangeManager {

    @Override
    public List<MaterialHierarchicalManagementRange> queryListByMaterialHierarchicalId(String materialHierarchicalId) {
        QueryWrapper<MaterialHierarchicalManagementRange> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("MATERIAL_HIERARCHICAL_ID_", materialHierarchicalId).eq("IS_DELE_", "0").orderByAsc("SN_");
        return this.list(queryWrapper);
    }

    @Override
    public void deleteByMaterialHierarchicalId(String materialHierarchicalId) {
        QueryWrapper<MaterialHierarchicalManagementRange> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("MATERIAL_HIERARCHICAL_ID_", materialHierarchicalId);
        this.remove(queryWrapper);
    }

    @Override
    public void deleteByMaterialHierarchicalIds(List<String> materialHierarchicalIds) {
        QueryWrapper<MaterialHierarchicalManagementRange> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("MATERIAL_HIERARCHICAL_ID_", materialHierarchicalIds);
        this.remove(queryWrapper);
    }
}
