package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagement;
import com.artfess.cgpt.material.dao.MaterialHierarchicalManagementDao;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.material.vo.MaterialHierarchicalManagementQueryVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 物料分级管理表 服务实现类
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@Service
public class MaterialHierarchicalManagementManagerImpl extends BaseManagerImpl<MaterialHierarchicalManagementDao, MaterialHierarchicalManagement> implements MaterialHierarchicalManagementManager {

    private MaterialHierarchicalManagementDao materialHierarchicalManagementDao;


    public PageList<MaterialHierarchicalManagementQueryVo> queryAllByPage(QueryFilter<MaterialHierarchicalManagement> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<MaterialHierarchicalManagement> currentModelClass = currentModelClass();
        IPage<MaterialHierarchicalManagementQueryVo> result = materialHierarchicalManagementDao.queryAllByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        List<MaterialHierarchicalManagementQueryVo> records = result.getRecords();
        PageList<MaterialHierarchicalManagementQueryVo> materialHierarchicalManagementQueryVoPageList = new PageList<>(result);
        materialHierarchicalManagementQueryVoPageList.setRows(getChildren(records));
        return materialHierarchicalManagementQueryVoPageList;
    }

    @Override
    public List<MaterialHierarchicalManagementQueryVo> queryAllByParentId(String parentId) {
        return materialHierarchicalManagementDao.queryAllByParentId(parentId);
    }

    @Override
    public int countByMatId(MaterialHierarchicalManagement t) {
        if(null == t){
            return 0;
        }
        QueryWrapper<MaterialHierarchicalManagement> queryWrapper = new QueryWrapper();
        queryWrapper.eq("IS_DELE_", "0").eq("MAT_ID_", t.getMatId()).eq("PARENT_ID_", t.getParentId());
        int count = this.count(queryWrapper);
        return count;
    }

    @Override
    public List<MaterialHierarchicalManagement> getParentById(String id) {
        MaterialHierarchicalManagement mh = this.getById(id);
        if(null == mh){
            return new ArrayList();
        }
        QueryWrapper<MaterialHierarchicalManagement> queryWrapper = new QueryWrapper();
        queryWrapper.eq("IS_DELE_", "0").eq("PARENT_ID_", mh.getId());
        List<MaterialHierarchicalManagement> materialHierarchicalList = this.list(queryWrapper);
        return getParent(materialHierarchicalList, materialHierarchicalList);
    }

    private List<MaterialHierarchicalManagement> getParent(List<MaterialHierarchicalManagement> resultList,List<MaterialHierarchicalManagement> list){
        if(null == list || list.size() == 0){
            return list;
        }
        // 查询下级数据
        for(MaterialHierarchicalManagement t: list){
            if(StringUtils.isBlank(t.getParentId()) || t.getParentId().equalsIgnoreCase("root")){
                continue;
            }
            QueryWrapper<MaterialHierarchicalManagement> queryWrapper = new QueryWrapper();
            queryWrapper.eq("IS_DELE_", "0").eq("PARENT_ID_", t.getId());
            List<MaterialHierarchicalManagement> materialHierarchicalList = this.list(queryWrapper);
            if(null != materialHierarchicalList && materialHierarchicalList.size() > 0){
                resultList.addAll(materialHierarchicalList);
                getParent(resultList, materialHierarchicalList);
            }
        }
        return resultList;
    }

    private List getChildren(List<MaterialHierarchicalManagementQueryVo> list){
        if(null == list || list.size() == 0){
            return list;
        }
        // 查询下级数据
        for(MaterialHierarchicalManagementQueryVo m : list){
            List<MaterialHierarchicalManagementQueryVo> materialHierarchicalList = materialHierarchicalManagementDao.queryAllByParentId(m.getId());
            if (null != list && list.size() > 0){
                getChildren(materialHierarchicalList);
                m.setChildren(materialHierarchicalList);
            }
        }
        return list;
    }


}
