package com.artfess.cgpt.material.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.model.Product;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/12 15:08
 */
public interface ProductManager extends BaseManager<Product> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<Product> queryAllByPage(QueryFilter<Product> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(Product entity);

    /**
     * 根据id修改状态
     * @param ids
     * @param status
     */
    void updateStatusByIds(String ids,String status);

    /**
     * 根据id集合删除
     * @param ids
     */
    void removeData(List<String> ids);

    /**
     * 根据id查询
     * @param id
     */
    Product getDataById(String id);

}
