package com.artfess.cgpt.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.docx4j.wml.U;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
@RestController
@RequestMapping("/bizMaterialCategory/v1/")
@Api(tags="物料分类")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMaterialCategoryController extends BaseController<BizMaterialCategoryManager, BizMaterialCategory> {

    @Autowired
    private UCFeignService ucFeignService;

    @PostMapping(value = "/selectTree")
    @ApiOperation(value = "M-查询物料分类树结构", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<List<BizMaterialCategory>> queryOrganization() {
        List<BizMaterialCategory> result = baseService.selectTree();
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizMaterialCategory>> queryByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterialCategory> queryFilter){
        PageList<BizMaterialCategory> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping(value = "/getEnterpriseCategoryTree")
    @ApiOperation(value = "M-查询企业授权物料分类树结构", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<List<BizMaterialCategory>> getEnterpriseCategoryTree() {
        List<BizMaterialCategory> result = baseService.getEnterpriseCategoryTree();
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping(value = "/getEnterpriseCategoryTreeByCode")
    @ApiOperation(value = "M-根据企业编码查询授权物料分类树结构", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<List<BizMaterialCategory>> getEnterpriseCategoryTreeByCode(@RequestParam("companyCode") String companyCode) {
        List<BizMaterialCategory> result = baseService.getEnterpriseCategoryTree(companyCode);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping(value = "/saveCategory")
    @ApiOperation(value = "M-添加或修改物料分类")
    public CommonResult<List<BizMaterialCategory>> saveCategory(@RequestBody BizMaterialCategory category) {
        baseService.saveOrUpdateEntity(category);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping(value = "/updateYqcCategory")
    @ApiOperation(value = "M-更新渝企采分类")
    public CommonResult<List<BizMaterialCategory>> updateYqcCategory(@RequestBody BizMaterialCategory category) {
        baseService.updateYqcCategory(category);
        return new CommonResult<>(true, "操作成功");
    }


    @PostMapping(value = "/deletCategory")
    @ApiOperation(value = "M-批量删除物料分类")
    public CommonResult<List<BizMaterialCategory>> deletCategory(@RequestParam List<String> ids) {
        String message = "删除成功";
        if (BizUtils.isAdmin(ucFeignService)) {
            message = "无权限，删除失败";
        } else {
            baseService.removeByIds(ids);
        }
        return new CommonResult<>(true, message);
    }

    @PostMapping(value = "/updateStatus")
    @ApiOperation(value = "M-修改物料分类状态")
    public CommonResult updateStatus(@RequestBody List<String> ids,@RequestParam String status) {
        baseService.updateStatus(ids,status);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/exportExcelData")
    @ApiOperation(value = "M-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportExcelData(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportExcelData(queryFilter,response);
        return new CommonResult<>("导出成功");
    }
}
