package com.artfess.cgpt.job;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.job.model.BaseJob;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:定时退还已签订合同成交供应商的保证金
 * @Author: Rong Tao
 * @Date: 2023/8/9 16:28
 */
public class AutoRefundBondJob extends BaseJob {

    protected Logger logger = LoggerFactory.getLogger(AutoRefundBondJob.class);

    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizContractManager contractManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    @Override
    public void executeJob(JobExecutionContext context) throws Exception {
        System.out.println("-----定时退还已签订合同成交供应商的保证金接口执行开始--时间："+ LocalDateTime.now()+"-----");

        //1.查询未退款的成交供应商参与数据
        List<UserParticipation> noRefundData = userParticipationManager.getNoRefundData();

        if(BeanUtils.isNotEmpty(noRefundData) && noRefundData.size()>0){
            for(UserParticipation userPart : noRefundData){
                //2.查询成交项目合同是否全部签订完成
                Integer noSignContrCount = contractManager.getNoSignContrCount(userPart.getNoticeId(),userPart.getCompanyId());

                if(noSignContrCount==0){
                    if(userPart.getNoticeType()==1){
                        //3.如果全部签订完成，退还保证金
                        MatApproval notice = matApprovalManager.getById(userPart.getNoticeId());
                        if(BeanUtils.isNotEmpty(notice.getBond()) && notice.getBond().compareTo(BigDecimal.ZERO)>0){
                            if(BeanUtils.isEmpty(userPart.getRegistrationOrderId())){
                                continue;
                            }
                            try {
                                //退还保证金
                                registrationOrderManager.refundBond(userPart);
                            }catch (Exception e){
                                e.printStackTrace();
                                System.out.println("定时退还已签订合同成交供应商的保证金接口执行失败："+e.getMessage());
                                logger.info("-----定时退还已签订合同成交供应商的保证金接口执行失败："+ e.getMessage()+"-----");
                            }
                        }
                    }
                }
            }
        }

        logger.info("-----定时退还已签订合同成交供应商的保证金接口执行完成--时间："+ LocalDateTime.now()+"-----");
    }

}
