package com.artfess.cgpt.foreignApi.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/2/20 16:04
 */
@Data
public class MhSucBidNoticeVO {

    @ApiModelProperty(value = "公告编号")
    private String projectCode;

    @ApiModelProperty(value = "公告标题")
    private String noticeTitle;

    @ApiModelProperty(value = "所属公司")
    private String affCompany;

    @ApiModelProperty(value = "所属类别（1.工程类，2.处置类，3.物资类，4.服务类，5.设备类）")
    private Integer category;

    @ApiModelProperty(value = "成交人")
    private String trader;

    @ApiModelProperty(value = "成交物资")
    private String dealMaterial;

    @ApiModelProperty(value = "成交价格（元）")
    private BigDecimal dealPrice;

    @ApiModelProperty(value = "成交时间")
    private LocalDateTime dealTime;

    @ApiModelProperty(value = "开标时间（开始竞价时间）")
    private LocalDateTime startAuctionTime;

    @ApiModelProperty(value = "结束时间（结束竞价时间）")
    private LocalDateTime endAuctionTime;

    @ApiModelProperty(value = "状态（1：已发布，2：已下架）")
    private Integer status;

//    @ApiModelProperty(value = "业务系统编码")
//    private String systemCode;
//
//    @ApiModelProperty(value = "业务系统名称")
//    private String systemName;

    @ApiModelProperty(value = "公告详情URL（业务系统详情页面的URL）")
    private String detailedUrl;
}
