package com.artfess.cgpt.expert.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 评标范围表，专家库_组织机构中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizExpertDatabaseOrg对象", description="评标范围表，专家库_组织机构中间表")
@Data
@TableName("biz_expert_database_org")
public class BizExpertDatabaseOrg extends BaseModel<BizExpertDatabaseOrg> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专家库ID")
    @TableField("EXPERT_DATABASE_ID_")
    private String expertDatabaseId;

    @ApiModelProperty(value = "组织ID（关联组织表ID）")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "状态（使用字典，0：启用，1禁用）")
    @TableField("STATUS_")
    private Integer status;

}
