package com.artfess.cgpt.expert.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 专家库管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
@ApiModel(value="BizExpertDatabase对象", description="专家库管理")
@Data
@TableName("biz_expert_database")
public class BizExpertDatabase extends BizModel<BizExpertDatabase> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户id")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "专家姓名")
    @TableField("FULLNAME_")
    private String fullname;

    @ApiModelProperty(value = "专家编号（使用流水号自动生成，【格式000001】）")
    @TableField("USER_NUMBER_")
    private String userNumber;

    @ApiModelProperty(value = "性别（男，女，未知）")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @TableField("BIRTHDAY_")
    private LocalDate birthday;

    @ApiModelProperty(value = "国家")
    @TableField("COUNTRY_")
    private String country;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "政治面貌（使用字典：01中共党员，02中共预备党员，03共青团员，04民革党员，05民盟盟员，06民建会员，07民进会员，08农工党党员，09致公党党员，10九三学社社员，11台盟盟员，12无党派人士，13群众）")
    @TableField("POLITICAL_OUTLOOK_")
    private String politicalOutlook;

    @ApiModelProperty(value = "身份证号")
    @TableField("ID_CARD_")
    private String idCard;

    @ApiModelProperty(value = "工作单位ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "工作单位编号")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "工作单位名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "工作地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "参加工作时间")
    @TableField("ENTRY_DATE_")
    private LocalDate entryDate;

    @ApiModelProperty(value = "专家类型（使用字典：1：内部专家，2：外部专家）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "职务")
    @TableField("DUTIES_")
    private String duties;

    @ApiModelProperty(value = "执业资质")
    @TableField("PROFESSIONAL_QUALIFICATIONS_")
    private String professionalQualifications;

    @ApiModelProperty(value = "学历")
    @TableField("EDUCATION_")
    private String education;

    @ApiModelProperty(value = "学位")
    @TableField("ACADEMIC_DEGREE_")
    private String academicDegree;

    @ApiModelProperty(value = "健康状况")
    @TableField("HEALTH_CONDITION_")
    private String healthCondition;

    @ApiModelProperty(value = "办公电话")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "手机号码")
    @TableField("MOBILE_")
    private String mobile;

    @ApiModelProperty(value = "QQ")
    @TableField("QQ_")
    private String qq;

    @ApiModelProperty(value = "MSN")
    @TableField("MSN_")
    private String msn;

    @ApiModelProperty(value = "邮箱")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "所属行政区划_ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_")
    private String sysAreasId;

    @ApiModelProperty(value = "所属行政区划_NAME（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_")
    private String sysAreasName;

    @ApiModelProperty(value = "所属行政区划_全路径ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_PATH_")
    private String sysAreasIdPath;

    @ApiModelProperty(value = "属行政区划_全路径名称（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_PATH_")
    private String sysAreasNamePath;

    @ApiModelProperty(value = "门户账号")
    @TableField("ACCOUNT_")
    private String account;

    @ApiModelProperty(value = "简历")
    @TableField("BIOGRAPHICAL_NOTES_")
    private String biographicalNotes;

    @ApiModelProperty(value = "照片附件URL")
    @TableField("PHOTO_")
    private String photo;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "专家级别")
    @TableField("GRADE_")
    private String grade;

    @ApiModelProperty(value = "毕业院校")
    @TableField("GRADUATION_INSTITUTION_")
    private String graduationInstitution;

    @ApiModelProperty(value = "状态（0：禁用，1：启用），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "评标类别（01：物资类，02：设备类，03：服务类，04：工程类）")
    @TableField("EVA_TYPE_")
    private String evaType;

    @ApiModelProperty(value = "专家分类集合")
    @TableField(exist = false)
    private List<BizExpertType> typeList;

    @ApiModelProperty(value = "资质集合")
    @TableField(exist = false)
    private List<BizQualificationLabel> qualificationLabelList;

    @ApiModelProperty(value = "评标范围集合")
    @TableField(exist = false)
    private List<Org> orgList;

    @ApiModelProperty(value = "是否新增账号(0：否，1：是)")
    @TableField(exist = false)
    private Integer isAddAccount;

    @ApiModelProperty(value = "评标类型集合")
    @TableField(exist = false)
    private List<BizExpertDatabaseEvaType> evaTypeList;

}
