package com.artfess.cgpt.expert.manager.impl;

import cn.hutool.json.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.dto.BizExpertDatabaseDTO;
import com.artfess.cgpt.expert.manager.*;
import com.artfess.cgpt.expert.model.*;
import com.artfess.cgpt.expert.dao.BizExpertDatabaseDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.BizUserVo;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.*;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 专家库管理 服务实现类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-22
 */
@Service
public class BizExpertDatabaseManagerImpl extends BaseManagerImpl<BizExpertDatabaseDao, BizExpertDatabase> implements BizExpertDatabaseManager {

    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private BizExpertDatabaseQualificationLabelManager expertDatabaseQualificationLabelManager;
    @Autowired
    private SystemConfigFeignService service;
    @Autowired
    private BizExpertDatabaseExpertTypeManager bizExpertDatabaseExpertTypeManager;
    @Autowired
    private BizExpertDatabaseOrgManager bizExpertDatabaseOrgManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizExpertTypeManager expertTypeManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private BizExpertDatabaseEvaTypeManager evaTypeManager;
    @Autowired
    private RoleManager roleManager;

    @Override
    public PageList<BizExpertDatabase> queryAllByPage(QueryFilter<BizExpertDatabase> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizExpertDatabase> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public BizExpertDatabase getDetailById(String id) {
        BizExpertDatabase result = super.getById(id);

        //查询资质
        result.setQualificationLabelList(expertDatabaseQualificationLabelManager.getByExpertId(id));

        //查询专家分类
        LambdaQueryWrapper<BizExpertDatabaseExpertType> expertTypeQW = new LambdaQueryWrapper<>();
        expertTypeQW.select(BizExpertDatabaseExpertType::getExpertTypeId)
                .eq(BizExpertDatabaseExpertType::getExpertDatabaseId, id);
        List<Object> typeIdsObj = bizExpertDatabaseExpertTypeManager.listObjs(expertTypeQW);
        if(BeanUtils.isNotEmpty(typeIdsObj) && typeIdsObj.size()>0){
            List<String> collect = typeIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            result.setTypeList(expertTypeManager.listByIds(collect));
        }

        //查询评标范围
        LambdaQueryWrapper<BizExpertDatabaseOrg> expertDatabaseOrgQW = new LambdaQueryWrapper<>();
        expertDatabaseOrgQW.select(BizExpertDatabaseOrg::getOrgId)
                .eq(BizExpertDatabaseOrg::getExpertDatabaseId, id)
                .eq(BizExpertDatabaseOrg::getStatus,0);
        List<Object> orgIdsObj = bizExpertDatabaseOrgManager.listObjs(expertDatabaseOrgQW);
        if(BeanUtils.isNotEmpty(orgIdsObj) && orgIdsObj.size()>0){
            List<String> collect = orgIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            result.setOrgList(orgManager.listByIds(collect));
        }

        return result;
    }

    //2024-07-19 18:58
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void saveOrUpdateEntity(BizExpertDatabase entity) {
//        List<BizQualificationLabel> bizQualificationLabelList = entity.getQualificationLabelList();
////        List<BizExpertDatabaseEvaType> evaTypeList = entity.getEvaTypeList();
//
//        // 查询专家库是否已存在
//        LambdaQueryWrapper<BizExpertDatabase> hisQW = new LambdaQueryWrapper<>();
//        hisQW.eq(BizExpertDatabase::getIdCard,entity.getIdCard())
//                .eq(BizExpertDatabase::getIsDele,"0")
//                .ne(BeanUtils.isNotEmpty(entity.getId()),BizExpertDatabase::getId,entity.getId());
//        int hisCount = super.count(hisQW);
//        if(hisCount>0){
//            throw new BaseException("操作失败，专家库身份证号【"+entity.getIdCard()+"】已存在");
//        }
//
//        // 处理专家个人信息
//        if (BeanUtils.isEmpty(entity.getId())) {
//            //新增
//            String cgpt_zjkgl = BizUtils.getNextSerialNumber(service, "cgpt_zjkgl");
//            entity.setUserNumber(cgpt_zjkgl);
//
//            if(BeanUtils.isNotEmpty(entity.getIsAddAccount()) && entity.getIsAddAccount()==1){
//                //新增用户到当前组织下
//                User user = new User();
//                user.setFullname(entity.getFullname());
//                user.setAccount(entity.getAccount());
//                user.setPassword("Spwz@"+entity.getMobile());
//                if(BeanUtils.isNotEmpty(entity.getEmail())){
//                    user.setEmail(entity.getEmail());
//                }
//                user.setMobile(entity.getMobile());
//                if(BeanUtils.isNotEmpty(entity.getAddress())){
//                    user.setAddress(entity.getAddress());
//                }
//                if(BeanUtils.isNotEmpty(entity.getSex())){
//                    user.setSex(entity.getSex());
//                }
//                user.setStatus(1);
//                user.setIdCard(entity.getIdCard());
//                user.setLockedStatus(1);
//                user.setUserType(2);
//                userManager.save(user);
//                OrgUser orgUser = new OrgUser();
//                orgUser.setOrgId(entity.getOrgId());
//                orgUser.setUserId(user.getId());
//                orgUser.setIsMaster(1);
//                orgUserManager.save(orgUser);
//
//                //推送用户到主数据并挂账到该组织下，设置采购平台权限
//                UserVo pushUser = new UserVo();
//                try {
//                    user.setId(null);
//                    BeanUtils.copyNotNullProperties(pushUser,user);
//                } catch (ReflectiveOperationException e) {
//                    e.printStackTrace();
//                }
//                pushUser.setSystemCode("jcsj,cgpt");
//                pushUser.setOrgCode(entity.getOrgCode());
//                JSONObject jsonObject = foreignCallService.pushUser(pushUser);
//                if(BeanUtils.isEmpty(jsonObject)){
//                    throw new BaseException("账号推送主数据失败");
//                }
//                if(BeanUtils.isEmpty(jsonObject.getStr("code"))){
//                    throw new BaseException("账号推送主数据失败:"+jsonObject);
//                }
//                if(!jsonObject.getStr("code").equals("0")){
//                    throw new BaseException("账号推送主数据失败:"+jsonObject.getStr("msg"));
//                }
//
//                //设置角色：一般用户、评标专家
//                roleManager.saveUserRoles("ybyh,pbzj",user.getAccount());
//            }
//
//        } else {
//            //更新
//            //删除已有关联数据
//            LambdaQueryWrapper<BizExpertDatabaseExpertType> qw1 = new LambdaQueryWrapper<>();
//            LambdaQueryWrapper<BizExpertDatabaseOrg> qw3 = new LambdaQueryWrapper<>();
//            qw1.eq(BizExpertDatabaseExpertType::getExpertDatabaseId, entity.getId());
//            qw3.eq(BizExpertDatabaseOrg::getExpertDatabaseId, entity.getId());
//            bizExpertDatabaseExpertTypeManager.remove(qw1);
//            bizExpertDatabaseOrgManager.remove(qw3);
//
//            //删除关联资质
//            LambdaQueryWrapper<BizQualificationLabel> qw2 = new LambdaQueryWrapper<>();
//            qw2.eq(BizQualificationLabel::getQualificationMemberId, entity.getId())
//                    .eq(BizQualificationLabel::getQualificationForm,2);
//            qualificationLabelManager.remove(qw2);
//
//            //删除关联评标类型
////            LambdaQueryWrapper<BizExpertDatabaseEvaType> evaTypeQW = new LambdaQueryWrapper<>();
////            evaTypeQW.eq(BizExpertDatabaseEvaType::getExpertDatabaseId,entity.getId());
////            evaTypeManager.remove(evaTypeQW);
//        }
//        super.saveOrUpdate(entity);
//
//        //添加关联数据
//        List<BizExpertType> typeList = entity.getTypeList();
////        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
//        List<Org> orgList = entity.getOrgList();
//        if (typeList != null && typeList.size() > 0) {
//            for (BizExpertType bizExpertType : typeList) {
//                BizExpertDatabaseExpertType entity1 = new BizExpertDatabaseExpertType();
//                entity1.setExpertDatabaseId(entity.getId());
//                entity1.setExpertTypeId(bizExpertType.getId());
//                bizExpertDatabaseExpertTypeManager.save(entity1);
//            }
//        }
//
////        if (qualificationLabelList != null && qualificationLabelList.size() > 0) {
////            for (BizQualificationLabel bizQualificationLabel : qualificationLabelList) {
////                BizExpertDatabaseQualificationLabel entity2 = new BizExpertDatabaseQualificationLabel();
////                entity2.setExpertDatabaseId(entity.getId());
////                entity2.setQualificationLabelId(bizQualificationLabel.getId());
////
////                List<Accessory> accessoryList = bizQualificationLabel.getAccessoryList();
////                if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
////                    accessoryList.stream().forEach(s -> {
////                        s.setSourceId(bizQualificationLabel.getId());
////                    });
////                    accessoryService.saveBatch(accessoryList);
////                }
////
////                bizExpertDatabaseQualificationLabelManager.save(entity2);
////            }
////        }
//
//        if (orgList != null && orgList.size() > 0) {
//            for (Org org : orgList) {
//                BizExpertDatabaseOrg entity3 = new BizExpertDatabaseOrg();
//                entity3.setExpertDatabaseId(entity.getId());
//                entity3.setOrgId(org.getId());
//                entity3.setStatus(0);
//                bizExpertDatabaseOrgManager.save(entity3);
//            }
//        }
//
////        if(BeanUtils.isNotEmpty(evaTypeList) && evaTypeList.size()>0){
////            evaTypeList.stream().forEach(s->s.setExpertDatabaseId(entity.getId()));
////            evaTypeManager.saveBatch(evaTypeList);
////        }
//
//        if (BeanUtils.isNotEmpty(bizQualificationLabelList) && bizQualificationLabelList.size()>0) {
//            // 处理专家资质信息
//            bizQualificationLabelList.stream().forEach(bizQualificationLabel->{
//                bizQualificationLabel.setQualificationMember(entity.getFullname());
//                bizQualificationLabel.setQualificationMemberId(entity.getId());
//                bizQualificationLabel.setQualificationForm(2);
//                qualificationLabelManager.saveOrUpdateEntity(bizQualificationLabel);
//
//                List<Accessory> accessoryList = bizQualificationLabel.getAccessoryList();
//                if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
//                    accessoryList.stream().forEach(s->s.setSourceId(bizQualificationLabel.getId()));
//                }
//            });
//        }
//    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizExpertDatabase entity) {
        List<BizQualificationLabel> bizQualificationLabelList = entity.getQualificationLabelList();
        // 查询专家库是否已存在
        LambdaQueryWrapper<BizExpertDatabase> hisQW = new LambdaQueryWrapper<>();
        hisQW.eq(BizExpertDatabase::getAccount,entity.getAccount())
                .eq(BizExpertDatabase::getIsDele,"0")
                .ne(BeanUtils.isNotEmpty(entity.getId()),BizExpertDatabase::getId,entity.getId());
        int hisCount = super.count(hisQW);
        if(hisCount>0){
            throw new BaseException("操作失败，专家账号【"+entity.getAccount()+"】已存在");
        }

        // 处理专家个人信息
        if (BeanUtils.isEmpty(entity.getId())) {
            //新增
            if(BeanUtils.isEmpty(entity.getUserNumber())){
                entity.setUserNumber(BizUtils.getNextSerialNumber(service, "cgpt_zjkgl"));
            }
            //设置角色：评标专家
            roleManager.saveUserRoles("pbzj",entity.getAccount());
        } else {
            //更新
            //删除已有关联数据
            LambdaQueryWrapper<BizExpertDatabaseExpertType> qw1 = new LambdaQueryWrapper<>();
            LambdaQueryWrapper<BizExpertDatabaseOrg> qw3 = new LambdaQueryWrapper<>();
            qw1.eq(BizExpertDatabaseExpertType::getExpertDatabaseId, entity.getId());
            qw3.eq(BizExpertDatabaseOrg::getExpertDatabaseId, entity.getId());
            bizExpertDatabaseExpertTypeManager.remove(qw1);
            bizExpertDatabaseOrgManager.remove(qw3);

            //删除关联资质
            LambdaQueryWrapper<BizExpertDatabaseQualificationLabel> qw2 = new LambdaQueryWrapper<>();
            qw2.eq(BizExpertDatabaseQualificationLabel::getExpertDatabaseId, entity.getId());
            expertDatabaseQualificationLabelManager.remove(qw2);

            //删除关联资质
//            LambdaQueryWrapper<BizQualificationLabel> qw2 = new LambdaQueryWrapper<>();
//            qw2.eq(BizQualificationLabel::getQualificationMemberId, entity.getId())
//                    .eq(BizQualificationLabel::getQualificationForm,2);
//            qualificationLabelManager.remove(qw2);

            //删除关联评标类型
//            LambdaQueryWrapper<BizExpertDatabaseEvaType> evaTypeQW = new LambdaQueryWrapper<>();
//            evaTypeQW.eq(BizExpertDatabaseEvaType::getExpertDatabaseId,entity.getId());
//            evaTypeManager.remove(evaTypeQW);
        }
        super.saveOrUpdate(entity);

        //添加关联数据
        List<BizExpertType> typeList = entity.getTypeList();
//        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        List<Org> orgList = entity.getOrgList();
        if (typeList != null && typeList.size() > 0) {
            for (BizExpertType bizExpertType : typeList) {
                BizExpertDatabaseExpertType entity1 = new BizExpertDatabaseExpertType();
                entity1.setExpertDatabaseId(entity.getId());
                entity1.setExpertTypeId(bizExpertType.getId());
                bizExpertDatabaseExpertTypeManager.save(entity1);
            }
        }

        if (orgList != null && orgList.size() > 0) {
            for (Org org : orgList) {
                BizExpertDatabaseOrg entity3 = new BizExpertDatabaseOrg();
                entity3.setExpertDatabaseId(entity.getId());
                entity3.setOrgId(org.getId());
                entity3.setStatus(0);
                bizExpertDatabaseOrgManager.save(entity3);
            }
        }

        if (BeanUtils.isNotEmpty(bizQualificationLabelList) && bizQualificationLabelList.size()>0) {
            List<BizExpertDatabaseQualificationLabel> expertDatabaseQualificationList = new ArrayList<>();
            //处理资质库信息
            bizQualificationLabelList.stream().forEach(bizQualificationLabel->{
                boolean quaIsAdd = false;
                if(BeanUtils.isEmpty(bizQualificationLabel.getId())){
                    quaIsAdd = true;
                    bizQualificationLabel.setQualificationMember(entity.getFullname());
                    bizQualificationLabel.setQualificationMemberId(entity.getUserId());
                    bizQualificationLabel.setQualificationForm(3);
                }
                qualificationLabelManager.saveOrUpdateEntity(bizQualificationLabel);
                if(quaIsAdd){
                    List<Accessory> accessoryList = bizQualificationLabel.getAccessoryList();
                    if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
                        accessoryList.stream().forEach(s->s.setSourceId(bizQualificationLabel.getId()));
                    }
                }

                //保存资质关联
                BizExpertDatabaseQualificationLabel expertDatabaseQualification = new BizExpertDatabaseQualificationLabel();
                expertDatabaseQualification.setExpertDatabaseId(entity.getId());
                expertDatabaseQualification.setQualificationLabelId(bizQualificationLabel.getId());
                expertDatabaseQualificationList.add(expertDatabaseQualification);
            });

            if(expertDatabaseQualificationList.size()>0){
                expertDatabaseQualificationLabelManager.saveBatch(expertDatabaseQualificationList);
            }

        }
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        //删除专家资质关联
        LambdaQueryWrapper<BizExpertDatabaseQualificationLabel> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizExpertDatabaseQualificationLabel::getExpertDatabaseId, ids);
        expertDatabaseQualificationLabelManager.remove(wrapper);

        LambdaQueryWrapper<BizExpertDatabaseExpertType> qw1 = new LambdaQueryWrapper<>();
        qw1.in(BizExpertDatabaseExpertType::getExpertDatabaseId, ids);
        bizExpertDatabaseExpertTypeManager.remove(qw1);

        LambdaQueryWrapper<BizExpertDatabaseOrg> qw3 = new LambdaQueryWrapper<>();
        qw3.in(BizExpertDatabaseOrg::getExpertDatabaseId, ids);
        bizExpertDatabaseOrgManager.remove(qw3);

        super.removeByIds(ids);
    }

}
