package com.artfess.cgpt.expert.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.dto.BizExpertDatabaseDTO;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 专家库管理 服务类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-22
 */
public interface BizExpertDatabaseManager extends BaseManager<BizExpertDatabase> {

    PageList<BizExpertDatabase> queryAllByPage(QueryFilter<BizExpertDatabase> queryFilter);

    BizExpertDatabase getDetailById(String id);
    /**
     * 保存或更新数据
     *
     * @param entity
     */
    void saveOrUpdateEntity(BizExpertDatabase entity);

    /**
     * 根据id集合删除
     * @param ids
     * @return
     */
    void removeByIds(List<String> ids);

}
