package com.artfess.cgpt.expert.controller;


import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.dto.BizExpertDatabaseDTO;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseExpertTypeManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseOrgManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseQualificationLabelManager;
import com.artfess.cgpt.expert.model.*;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseManager;

import java.util.Arrays;
import java.util.List;

/**
 * 专家库管理 前端控制器
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-22
 */
@RestController
@RequestMapping("/bizExpertDatabase/v1/")
@Api(tags = "专家库管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizExpertDatabaseController extends BaseController<BizExpertDatabaseManager, BizExpertDatabase> {

    @Autowired
    private BizExpertDatabaseQualificationLabelManager expertDatabaseQualificationLabelManager;

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizExpertDatabase>> queryAllByPage(@RequestBody QueryFilter<BizExpertDatabase> queryFilter) {
        PageList<BizExpertDatabase> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizExpertDatabase> selectOne(@RequestParam("id") String id) {
        BizExpertDatabase result = baseService.getDetailById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除专家")
    public CommonResult remove(@RequestParam("ids") String ids) {
        baseService.removeByIds(Arrays.asList(ids.split(",")));
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-保存或更新专家")
    public CommonResult save(@RequestBody BizExpertDatabase entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

}
