package com.artfess.cgpt.evaluation.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemUseOrgManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationItem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.dao.BizEvaluationSystemDao;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemUseOrg;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 评标体系表，综合评标法/最低价评标法都用此表，综合评标法有明细，最低价评标法无明细 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizEvaluationSystemManagerImpl extends BaseManagerImpl<BizEvaluationSystemDao, BizEvaluationSystem> implements BizEvaluationSystemManager {

    @Autowired
    UCFeignService ucFeignService;

    @Autowired
    private BizEvaluationSystemDescriptionManager evaluationSystemDescriptionManager;

    @Autowired
    private BizEvaluationSystemUseOrgManager evaluationSystemUseOrgManager;

    @Autowired
    private OrgManager orgManager;

    @Autowired
    private SystemConfigFeignService systemConfigFeignService;

    @Override
    public PageList<BizEvaluationSystem> queryAllByPage(QueryFilter<BizEvaluationSystem> queryFilter) {
        IPage<BizEvaluationSystem> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean())
                ,convert2Wrapper(queryFilter, currentModelClass()));

//        List<BizEvaluationSystem> rows = result.getRecords();
//        //设置使用单位
//        for(BizEvaluationSystem system : rows){
//            QueryFilter<BizEvaluationSystemUseOrg> useOrgQF = QueryFilter.build();
//            useOrgQF.addFilter("euo.EVALUATION_SYSTEM_ID_",system.getId(),QueryOP.EQUAL);
//            useOrgQF.addFilter("org.is_dele_","0",QueryOP.EQUAL);
//            system.setOrgs(evaluationSystemUseOrgManager.getUseOrgList(useOrgQF));
//        }

        return new PageList<>(result);

    }

    @Override
    public PageList<BizEvaluationSystem> pageDetail(QueryFilter<BizEvaluationSystem> queryFilter) {
        IPage<BizEvaluationSystem> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean())
                ,convert2Wrapper(queryFilter, currentModelClass()));

        List<BizEvaluationSystem> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizEvaluationSystem temp : records){
                LambdaQueryWrapper<BizEvaluationSystemDescription> descriptionQW = new LambdaQueryWrapper<>();
                descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId,temp.getId());
                temp.setDescriptionList(evaluationSystemDescriptionManager.list(descriptionQW));
            }
        }

        return new PageList<>(result);

    }

    @Override
    public PageList<BizEvaluationSystem> queryByPage(QueryFilter<BizEvaluationSystem> queryFilter) {
        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"PREPARED_ORG_ID_");
        IPage<BizEvaluationSystem> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean())
                ,convert2Wrapper(queryFilter, currentModelClass()));

//        List<BizEvaluationSystem> rows = result.getRecords();
//        //设置使用单位
//        for(BizEvaluationSystem system : rows){
//            QueryFilter<BizEvaluationSystemUseOrg> useOrgQF = QueryFilter.build();
//            useOrgQF.addFilter("euo.EVALUATION_SYSTEM_ID_",system.getId(),QueryOP.EQUAL);
//            useOrgQF.addFilter("org.is_dele_","0",QueryOP.EQUAL);
//            system.setOrgs(evaluationSystemUseOrgManager.getUseOrgList(useOrgQF));
//        }

        return new PageList<>(result);

    }

    @Override
    public PageList<BizEvaluationSystem> queryByUseOrg(QueryFilter<BizEvaluationSystem> queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        String useOrgId = null;
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf :  querys){
                if(qf.getProperty().equals("useOrgId")){
                    useOrgId = String.valueOf(qf.getValue());
                    qf.setProperty("1");
                    qf.setValue("1");
                    break;
                }
            }
        }

        if(BeanUtils.isNotEmpty(useOrgId)){
            //1.查询评标使用单位关联表
            LambdaQueryWrapper<BizEvaluationSystemUseOrg> useOrgQW = new LambdaQueryWrapper<>();
            useOrgQW.select(BizEvaluationSystemUseOrg::getEvaluationSystemId)
                    .eq(BizEvaluationSystemUseOrg::getOrgId,useOrgId);
            List<Object> objList = evaluationSystemUseOrgManager.listObjs(useOrgQW);
            if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
                List<String> evaSysIds = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("ID_", evaSysIds, QueryOP.IN);
            }

        }

        IPage<BizEvaluationSystem> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean())
                ,convert2Wrapper(queryFilter, currentModelClass()));

//        List<BizEvaluationSystem> rows = result.getRecords();
//        //设置使用单位
//        for(BizEvaluationSystem system : rows){
//            QueryFilter<BizEvaluationSystemUseOrg> useOrgQF = QueryFilter.build();
//            useOrgQF.addFilter("euo.EVALUATION_SYSTEM_ID_",system.getId(),QueryOP.EQUAL);
//            useOrgQF.addFilter("org.is_dele_","0",QueryOP.EQUAL);
//            system.setOrgs(evaluationSystemUseOrgManager.getUseOrgList(useOrgQF));
//        }

        return new PageList<>(result);

    }

    //2024-07-03 18:23
//    @Override
//    @Transactional
//    public void saveOrUpdateEntity(BizEvaluationSystem entity) {
//        boolean isUpdate = false;
//        if(BeanUtils.isNotEmpty(entity.getId())) {
//        isUpdate = true;
//        }
//
//        if(BeanUtils.isEmpty(entity.getCode())){
//            entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"cgpt_zjkgl"));
//        }
//
//        super.saveOrUpdate(entity);
//
//        if (!entity.getEvaluatingMethods().equals("2")) {
//            //如果评标方式不是最低评标法
//            if(isUpdate){
//                //如果是更新，删除已有评标明细
//                LambdaQueryWrapper<BizEvaluationSystemDescription> descriptionQW = new LambdaQueryWrapper<>();
//                descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, entity.getId());
//                evaluationSystemDescriptionManager.remove(descriptionQW);
//            }
//
//            //添加评标明细
//            List<BizEvaluationSystemDescription> descriptionList = entity.getDescriptionList();
//            if(BeanUtils.isNotEmpty(descriptionList) && descriptionList.size()>0){
//                descriptionList.stream().forEach(s->s.setEvaluationSystemId(entity.getId()));
//                evaluationSystemDescriptionManager.saveBatch(descriptionList);
//            }
//        }
//
//        if(isUpdate){
//            //如果是更新，删除使用单位集合
//            LambdaQueryWrapper<BizEvaluationSystemUseOrg> useOrgQW = new LambdaQueryWrapper<>();
//            useOrgQW.eq(BizEvaluationSystemUseOrg::getEvaluationSystemId, entity.getId());
//            evaluationSystemUseOrgManager.remove(useOrgQW);
//        }
//        //保存使用单位集合
//        List<BizEvaluationSystemUseOrg> useOrgList = entity.getUseOrgList();
//        if(BeanUtils.isNotEmpty(useOrgList) && useOrgList.size()>0){
//            useOrgList.stream().forEach(s->s.setEvaluationSystemId(entity.getId()));
//            evaluationSystemUseOrgManager.saveBatch(useOrgList);
//        }
//
//    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizEvaluationSystem entity) {
        boolean isUpdate = false;
        if(BeanUtils.isNotEmpty(entity.getId())) {
            isUpdate = true;
        }

        super.saveOrUpdate(entity);


        //如果评标方式不是最低评标法
        if(isUpdate){
            //如果是更新，删除已有评标明细
            LambdaQueryWrapper<BizEvaluationSystemDescription> descriptionQW = new LambdaQueryWrapper<>();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, entity.getId());
            evaluationSystemDescriptionManager.remove(descriptionQW);
        }

        //添加评标明细
        List<BizEvaluationSystemDescription> descriptionList = entity.getDescriptionList();
        if(BeanUtils.isNotEmpty(descriptionList) && descriptionList.size()>0){
            descriptionList.stream().forEach(s->s.setEvaluationSystemId(entity.getId()));
            evaluationSystemDescriptionManager.saveBatch(descriptionList);
        }

        if(isUpdate){
            //如果是更新，删除使用单位集合
            LambdaQueryWrapper<BizEvaluationSystemUseOrg> useOrgQW = new LambdaQueryWrapper<>();
            useOrgQW.eq(BizEvaluationSystemUseOrg::getEvaluationSystemId, entity.getId());
            evaluationSystemUseOrgManager.remove(useOrgQW);
        }
        //保存使用单位集合
        List<BizEvaluationSystemUseOrg> useOrgList = entity.getUseOrgList();
        if(BeanUtils.isNotEmpty(useOrgList) && useOrgList.size()>0){
            useOrgList.stream().forEach(s->s.setEvaluationSystemId(entity.getId()));
            evaluationSystemUseOrgManager.saveBatch(useOrgList);
        }

    }

    @Override
    public BizEvaluationSystem getDataById(String id) {
        BizEvaluationSystem result = super.getById(id);
        //查询评分明细
        result.setDescriptionList(evaluationSystemDescriptionManager.selectBySysId(id));

        //查询使用单位
        QueryFilter<BizEvaluationSystemUseOrg> useOrgQF = QueryFilter.build();
        useOrgQF.addFilter("euo.EVALUATION_SYSTEM_ID_",id,QueryOP.EQUAL);
        result.setOrgs(evaluationSystemUseOrgManager.getUseOrgList(useOrgQF));
        return result;
    }

//    private List<Org> queryOrg(String id){
//        QueryWrapper<BizEvaluationSystemUseOrg> evaUseOrgQW = new QueryWrapper<>();
//        evaUseOrgQW.select("distinct ORG_ID_")
//                .eq("EVALUATION_SYSTEM_ID_", id);
//        List<Object> orgIdObjs = evaluationSystemUseOrgManager.listObjs(evaUseOrgQW);
//        if(BeanUtils.isEmpty(orgIdObjs) || orgIdObjs.size()<=0) return new ArrayList<>();
//
//        List<String> orgIds = orgIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
//
//        QueryWrapper<Org> wrapper=new QueryWrapper<>();
//        wrapper.in("id_",orgIds);
//        return orgManager.list(wrapper);
//    }

}
