package com.artfess.cgpt.evaluation.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.base.manager.BaseManager;

/**
 * 评标体系表，综合评标法/最低价评标法都用此表，综合评标法有明细，最低价评标法无明细 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizEvaluationSystemManager extends BaseManager<BizEvaluationSystem> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizEvaluationSystem> queryAllByPage(QueryFilter<BizEvaluationSystem> queryFilter);

    /**
     * 分页查询所有数据（包含明细）
     * @param queryFilter
     * @return
     */
    PageList<BizEvaluationSystem> pageDetail(QueryFilter<BizEvaluationSystem> queryFilter);

    /**
     * 分页查询数据（编制单位过滤）
     * @param queryFilter
     * @return
     */
    PageList<BizEvaluationSystem> queryByPage(QueryFilter<BizEvaluationSystem> queryFilter);

    /**
     * 分页查询数据（使用单位过滤）
     * @param queryFilter
     * @return
     */
    PageList<BizEvaluationSystem> queryByUseOrg(QueryFilter<BizEvaluationSystem> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(BizEvaluationSystem entity);

    /**
     * 根据id查询详情
     * @param id 主键id
     */
    BizEvaluationSystem getDataById(String id);

}
