package com.artfess.cgpt.evaluation.controller;


import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.evaluation.model.BizEvaluationItem;
import com.artfess.cgpt.evaluation.manager.BizEvaluationItemManager;

import java.util.List;

/**
 * 评标项目表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizEvaluationItem/v1/")
@Api(tags="评标项目表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEvaluationItemController extends BaseController<BizEvaluationItemManager, BizEvaluationItem> {
    @Autowired
    private SystemConfigFeignService service;
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizEvaluationItem>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizEvaluationItem> queryFilter){
        PageList<BizEvaluationItem> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @RequestMapping(value = "/selectTree", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-查询评标项目树结构", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<List<BizEvaluationItem>> queryOrganization() {
        List<BizEvaluationItem> result = baseService.selectTree();
        return new CommonResult<>(true, "查询成功", result);
    }

    @RequestMapping(value = "/saveItem", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-添加或修改评标项目")
    public CommonResult<List<BizEvaluationItem>> saveItem( @RequestBody BizEvaluationItem entity) {
        String message = "操作成功";
        String nextIdByAlias = service.getNextIdByAlias("cgpt_pbxm");
        JSONObject jsonObject = new JSONObject(nextIdByAlias);
        Object value = jsonObject.get("value");
        String s = value.toString();
        entity.setSubjectCode(s);
        baseService.saveOrUpdate(entity);
        return new CommonResult<>(true, message);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizEvaluationItem> selectOne(@ApiParam(name="queryfilter",value = "通用查询器")@RequestParam String id){
//        BizExpertDatabase result=baseService.getExpertById(id);
        BizEvaluationItem result = baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除评标项目")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }
}
